/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.support_vector_machine;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.support_vector_machine.Coefficient;
import org.dmg.pmml.support_vector_machine.Coefficients;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.dmg.pmml.support_vector_machine.SupportVector;
import org.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.support_vector_machine.SupportVectors;
import org.dmg.pmml.support_vector_machine.VectorDictionary;
import org.dmg.pmml.support_vector_machine.VectorFields;
import org.dmg.pmml.support_vector_machine.VectorInstance;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Matrix;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.ValueUtil;

public class LibSVMUtil {
    private LibSVMUtil() {
    }

    public static SupportVectorMachineModel createRegression(Kernel kernel, Matrix<? extends Number> sv, List<String> ids, Number rho, List<? extends Number> coefs, Schema schema) {
        ContinuousLabel continuousLabel = (ContinuousLabel)schema.getLabel();
        VectorDictionary vectorDictionary = LibSVMUtil.createVectorDictionary(sv, ids, schema);
        List vectorInstances = vectorDictionary.getVectorInstances();
        ArrayList<SupportVectorMachine> supportVectorMachines = new ArrayList<SupportVectorMachine>();
        supportVectorMachines.add(LibSVMUtil.createSupportVectorMachine(vectorInstances, rho, coefs));
        SupportVectorMachineModel supportVectorMachineModel = new SupportVectorMachineModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema(continuousLabel), kernel, vectorDictionary, supportVectorMachines);
        return supportVectorMachineModel;
    }

    public static SupportVectorMachineModel createClassification(Kernel kernel, Matrix<? extends Number> sv, List<Integer> nSv, List<String> ids, List<? extends Number> rho, List<? extends Number> coefs, Schema schema) {
        int i;
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        int numberOfVectors = sv.getRows();
        int numberOfFeatures = sv.getColumns();
        VectorDictionary vectorDictionary = LibSVMUtil.createVectorDictionary(sv, ids, schema);
        List vectorInstances = vectorDictionary.getVectorInstances();
        ArrayList<SupportVectorMachine> supportVectorMachines = new ArrayList<SupportVectorMachine>();
        int[] offsets = new int[nSv.size() + 1];
        for (i = 0; i < nSv.size(); ++i) {
            offsets[i + 1] = offsets[i] + nSv.get(i);
        }
        i = 0;
        int size = categoricalLabel.size();
        for (int first = 0; first < size; ++first) {
            for (int second = first + 1; second < size; ++second) {
                ArrayList<VectorInstance> svmVectorInstances = new ArrayList<VectorInstance>();
                svmVectorInstances.addAll(LibSVMUtil.slice(vectorInstances, offsets, first));
                svmVectorInstances.addAll(LibSVMUtil.slice(vectorInstances, offsets, second));
                Number svmRho = rho.get(i);
                ArrayList<Number> svmCoefs = new ArrayList<Number>();
                svmCoefs.addAll(LibSVMUtil.slice(CMatrixUtil.getRow(coefs, size - 1, numberOfVectors, second - 1), offsets, first));
                svmCoefs.addAll(LibSVMUtil.slice(CMatrixUtil.getRow(coefs, size - 1, numberOfVectors, first), offsets, second));
                SupportVectorMachine supportVectorMachine = LibSVMUtil.createSupportVectorMachine(svmVectorInstances, svmRho, svmCoefs).setTargetCategory(categoricalLabel.getValue(first)).setAlternateTargetCategory(categoricalLabel.getValue(second));
                supportVectorMachines.add(supportVectorMachine);
                ++i;
            }
        }
        SupportVectorMachineModel supportVectorMachineModel = new SupportVectorMachineModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema(categoricalLabel), kernel, vectorDictionary, supportVectorMachines).setClassificationMethod(SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ONE);
        return supportVectorMachineModel;
    }

    public static VectorDictionary createVectorDictionary(Matrix<? extends Number> sv, List<String> ids, Schema schema) {
        int numberOfVectors = sv.getRows();
        int numberOfFeatures = sv.getColumns();
        List<? extends Feature> features = schema.getFeatures();
        SchemaUtil.checkSize(numberOfFeatures, features);
        BitSet featureMask = new BitSet(numberOfFeatures);
        Double defaultValue = 0.0;
        for (int i = 0; i < numberOfVectors; ++i) {
            List<? extends Number> values = sv.getRowValues(i);
            BitSet vectorFeatureMask = ValueUtil.getIndices(values, defaultValue);
            vectorFeatureMask.flip(0, numberOfFeatures);
            featureMask.or(vectorFeatureMask);
        }
        int numberOfUsedFeatures = featureMask.cardinality();
        VectorFields vectorFields = new VectorFields();
        for (int i = 0; i < numberOfFeatures; ++i) {
            Feature feature = schema.getFeature(i);
            if (!featureMask.get(i)) continue;
            if (feature instanceof BinaryFeature) {
                BinaryFeature binaryFeature = (BinaryFeature)feature;
                CategoricalPredictor categoricalPredictor = new CategoricalPredictor().setField(binaryFeature.getName()).setValue(binaryFeature.getValue()).setCoefficient((Number)1.0);
                vectorFields.addContent(new PMMLObject[]{categoricalPredictor});
                continue;
            }
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            vectorFields.addContent(new PMMLObject[]{continuousFeature.ref()});
        }
        VectorDictionary vectorDictionary = new VectorDictionary(vectorFields);
        for (int i = 0; i < numberOfVectors; ++i) {
            String id = ids.get(i);
            List<? extends Number> values = sv.getRowValues(i);
            if (numberOfUsedFeatures < numberOfFeatures) {
                values = ValueUtil.filterByIndices(values, featureMask);
            }
            VectorInstance vectorInstance = ValueUtil.isSparse(values, defaultValue, 0.75) ? new VectorInstance(id, PMMLUtil.createRealSparseArray(values, defaultValue), null) : new VectorInstance(id, null, PMMLUtil.createRealArray(values));
            vectorDictionary.addVectorInstances(new VectorInstance[]{vectorInstance});
        }
        return vectorDictionary;
    }

    public static SupportVectorMachine createSupportVectorMachine(List<VectorInstance> vectorInstances, Number rho, List<? extends Number> coefs) {
        if (vectorInstances.size() != coefs.size()) {
            throw new IllegalArgumentException();
        }
        Coefficients coefficients = new Coefficients().setAbsoluteValue(rho);
        SupportVectors supportVectors = new SupportVectors();
        for (int i = 0; i < vectorInstances.size(); ++i) {
            VectorInstance vectorInstance = vectorInstances.get(i);
            Coefficient coefficient = new Coefficient().setValue(coefs.get(i));
            coefficients.addCoefficients(new Coefficient[]{coefficient});
            SupportVector supportVector = new SupportVector(vectorInstance.getId());
            supportVectors.addSupportVectors(new SupportVector[]{supportVector});
        }
        SupportVectorMachine supportVectorMachine = new SupportVectorMachine(coefficients).setSupportVectors(supportVectors);
        return supportVectorMachine;
    }

    private static <E> List<E> slice(List<E> list, int[] offsets, int index) {
        return list.subList(offsets[index], offsets[index + 1]);
    }
}

