/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.model.ToStringHelper;

public class CategoricalFeature
extends Feature {
    private List<?> values = null;

    public <F extends Field<F>> CategoricalFeature(PMMLEncoder encoder, F field) {
        this(encoder, field, PMMLUtil.getValues(field));
    }

    public CategoricalFeature(PMMLEncoder encoder, Field<?> field, List<?> values) {
        this(encoder, field.getName(), field.getDataType(), values);
    }

    public CategoricalFeature(PMMLEncoder encoder, Feature feature, List<?> values) {
        this(encoder, feature.getName(), feature.getDataType(), values);
    }

    public CategoricalFeature(PMMLEncoder encoder, FieldName name, DataType dataType, List<?> values) {
        super(encoder, name, dataType);
        this.setValues(values);
    }

    @Override
    public ContinuousFeature toContinuousFeature() {
        PMMLEncoder encoder = this.getEncoder();
        Field<?> field = encoder.toContinuous(this.getName());
        return new ContinuousFeature(encoder, field);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.getValues());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CategoricalFeature) {
            CategoricalFeature that = (CategoricalFeature)object;
            return super.equals(object) && Objects.equals(this.getValues(), that.getValues());
        }
        return false;
    }

    @Override
    protected ToStringHelper toStringHelper() {
        return super.toStringHelper().add("values", this.getValues());
    }

    public int size() {
        List<?> values = this.getValues();
        return values.size();
    }

    public Object getValue(int index) {
        List<?> values = this.getValues();
        return values.get(index);
    }

    public List<?> getValues() {
        return this.values;
    }

    private void setValues(List<?> values) {
        if ((values = Objects.requireNonNull(values)).isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.values = values;
    }
}

