from typing import Mapping
from typing import Optional
from typing import Text

from qbittorrentapi._types import JsonDictionaryT
from qbittorrentapi._types import JsonValueT
from qbittorrentapi._types import KwargsT
from qbittorrentapi.definitions import ClientCache
from qbittorrentapi.request import Request

class ApplicationPreferencesDictionary(JsonDictionaryT): ...
class BuildInfoDictionary(JsonDictionaryT): ...

class Application(ClientCache):
    @property
    def version(self) -> Text: ...
    @property
    def web_api_version(self) -> Text: ...
    @property
    def webapiVersion(self) -> Text: ...
    @property
    def build_info(self) -> BuildInfoDictionary: ...
    @property
    def buildInfo(self) -> BuildInfoDictionary: ...
    def shutdown(self) -> None: ...
    @property
    def preferences(self) -> ApplicationPreferencesDictionary: ...
    @preferences.setter
    def preferences(self, value: Mapping[Text, JsonValueT]) -> None: ...
    def set_preferences(
        self,
        prefs: Optional[Mapping[Text, JsonValueT]] = None,
        **kwargs: KwargsT,
    ) -> None: ...
    setPreferences = set_preferences
    @property
    def default_save_path(self) -> Text: ...
    @property
    def defaultSavePath(self) -> Text: ...

class AppAPIMixIn(Request):
    @property
    def app(self) -> Application: ...
    @property
    def application(self) -> Application: ...
    def app_version(self, **kwargs: KwargsT) -> str: ...
    def app_web_api_version(self, **kwargs: KwargsT) -> str: ...
    app_webapiVersion = app_web_api_version
    def app_build_info(self, **kwargs: KwargsT) -> BuildInfoDictionary: ...
    app_buildInfo = app_build_info
    def app_shutdown(self, **kwargs: KwargsT) -> None: ...
    def app_preferences(
        self,
        **kwargs: KwargsT,
    ) -> ApplicationPreferencesDictionary: ...
    def app_set_preferences(
        self,
        prefs: Optional[Mapping[Text, JsonValueT]] = None,
        **kwargs: KwargsT,
    ) -> None: ...
    app_setPreferences = app_set_preferences
    def app_default_save_path(self, **kwargs: KwargsT) -> str: ...
    app_defaultSavePath = app_default_save_path
