# openai-finetune
Fine-tuning client for OpenAI API

## Overview
Fine-tuning process with OpenAI API consists of three stages:

1. Preparing the data in jsonl format
2. Running the fine-tuning job
3. Evaluating fine-tuning results
4. Serving the snapshot that resulted from fine-tuning


Guidelines on data preparation can be found [here](https://docs.google.com/document/d/1TiMS_dmZydHJszDTSdM6z1vVDgUvmwzAMDN-oB_uV8o/edit#heading=h.p5fblbn71xfs)
Serving the fine-tuned models is currently manual (via spinning up a new engine with a correct snapshot);
however, it is an area of active development. Contact @peterz or @michael to learn about latest status.

The `openai-finetune` client helps primarily with items 2 and 3 (running fine-tuning jobs and evaluating the results).

OpenAI API currently supports finetuning in two modes - sync mode and batch mode
In [sync mode](docs/sync_mode.md), the client communicates data for each model update to the engine and
waits for the result of the update synchronously.

In [batch mode](docs/batch_mode.md), a series of commands is queued as a fine-tuning plan.
The API then executes the commands on an available engine and communicates back the
results as soon as they are ready.

Both modes evaluate training and validation losses at minibatch level (one update on a training minibatch is followed
by one validation minibatch). This allows us reporting validation loss thoughout the epoch (not only at the end).
However, this also leads to noisy estimates of the validation loss.

## CLI commands
After openai-finetune is installed, the following CLI commands are available:

 - `openai-ft` -- general entry point to start fine-tuning jobs
 - `openai-ft-classification` -- similar to openai-ft, but with default values optimized for classification fine-tuning
 - `openai-ft-events` -- listen to events generated by a batch-mode fine-tuning run
 - `openai-ft-report` -- similar to openai-ft-everts, but also produce a jupyter notebook with a report about the fine-tuning job

Detailed info about CLI options can be found by using `--help` flag.

## Comparison with easyfinetune baselines
Reports and comparisons with easyfinetune on subreddit classification, koko abuse detection, and koko crisis detection tasks
are available in [this doc](https://docs.google.com/document/d/1wYvCJxVMewWn_JNTGWE4DATm1LapLEmwVACSS4fD7Po/edit?usp=sharing).

## Developer and admin docs
The code is not super-polished at the moment, and chances are one will need to look under the hood. Starting point to do
that is [here](docs/api_admin.md)
