#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import print_function
from os import system
from os.path import isfile
import numpy as np
from ase import Atoms
from ase.io.trajectory import TrajectoryWriter
from ase.calculators.singlepoint import SinglePointCalculator


def readposcars(poscars,energies='goodStructures'):
    ''' read POSCARS generated by USPEX''' 
    f = open(poscars,'r')
    lines = f.readlines()
    f.close()

    f = open(energies,'r')
    linee = f.readlines()
    f.close()
    
    e = []
    for i,le in enumerate(linee):
    	if i>1:
           e.append(float(le.split()[-4]))

    l = lines[6].split()
    natom = 0
    for i in l:
        natom += int(i)

    nstru = len(lines)/(natom+8)
    traj  = TrajectoryWriter('strucs.traj',mode='w')

    for i in range(nstru):
        nl = i*(natom+8)
        cl1 = lines[nl+2].split()
        cl2 = lines[nl+3].split()
        cl3 = lines[nl+4].split()
        cell = [[float(cl1[0]),float(cl1[1]),float(cl1[2])],
                [float(cl2[0]),float(cl2[1]),float(cl2[2])],
                [float(cl3[0]),float(cl3[1]),float(cl3[2])]]
        cell = np.array(cell)

        anl = lines[nl+5].split()
        nsl = lines[nl+6].split()

        atom_name = []
        for i_,sp in enumerate(anl):
            atom_name.extend([sp]*int(nsl[i_]))

        xf = []
        for na in range(natom):
        	xl = lines[nl+8+na].split()
        	xf.append([float(xl[0]),float(xl[1]),float(xl[2])])
        xf = np.array(xf)
        x  = np.dot(xf,cell)

        A  = Atoms(atom_name,x,cell=cell,pbc=[True,True,True])
        calc = SinglePointCalculator(A,energy=e[i])
        # print(e[i])

        A.set_calculator(calc)
        traj.write(atoms=A)
    traj.close()


if __name__ == '__main__':
   readposcars('goodStructures_POSCARS')



