/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.util.ClassUtil;

public class TypeMap {
    private Map<String, Class<?>> typesByName;

    public TypeMap(int initialSize) {
        this.typesByName = new HashMap(initialSize);
    }

    public TypeMap(Class<?> ... types) {
        this(types.length);
        this.add(types);
    }

    public void add(Class<?> type) {
        String shortName = ClassUtil.withoutPackageName(type.getName());
        Class<?> existingType = this.typesByName.get(shortName);
        if (existingType == null) {
            this.typesByName.put(type.getName(), type);
            this.typesByName.put(shortName, type);
            return;
        }
        if (existingType != type) {
            throw new IllegalArgumentException("Short name collision between existing " + existingType + " and new " + type);
        }
    }

    public boolean contains(Class<?> type) {
        return this.typesByName.containsValue(type);
    }

    public boolean contains(String typeName) {
        return this.typesByName.containsKey(typeName);
    }

    public Class<?> typeFor(String typeName) {
        return this.typesByName.get(typeName);
    }

    public void add(Class<?> ... types) {
        for (Class<?> element : types) {
            this.add(element);
        }
    }

    public Map<Class<?>, String> asInverseWithShortName() {
        HashMap inverseMap = new HashMap(this.typesByName.size() / 2);
        for (Map.Entry<String, Class<?>> entry : this.typesByName.entrySet()) {
            this.storeShortest(inverseMap, entry.getValue(), entry.getKey());
        }
        return inverseMap;
    }

    public int size() {
        return this.typesByName.size();
    }

    private void storeShortest(Map<Class<?>, String> map, Class<?> key, String value) {
        String existingValue = map.get(key);
        if (existingValue == null) {
            map.put(key, value);
            return;
        }
        if (existingValue.length() < value.length()) {
            return;
        }
        map.put(key, value);
    }
}

