/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.controls;

import javafx.scene.control.TreeCell;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.plsql.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;
import net.sourceforge.pmd.util.fxdesigner.MainDesignerController;

public class ScopeHierarchyTreeCell
extends TreeCell<Object> {
    private final MainDesignerController controller;

    public ScopeHierarchyTreeCell(MainDesignerController controller) {
        this.controller = controller;
    }

    protected void updateItem(Object item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.setText(item instanceof Scope ? this.getTextForScope((Scope)item) : this.getTextForDeclaration((NameDeclaration)item));
        }
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, t -> {
            if (t.getButton() == MouseButton.PRIMARY && this.getTreeView().getSelectionModel().getSelectedItem() == item && item instanceof NameDeclaration) {
                this.controller.onNodeItemSelected((Node)((NameDeclaration)item).getNode());
            }
        });
    }

    private String getTextForScope(Scope scope) {
        return scope.getClass().getSimpleName();
    }

    private String getTextForDeclaration(NameDeclaration declaration) {
        StringBuilder sb = new StringBuilder();
        if (declaration instanceof MethodNameDeclaration || declaration instanceof net.sourceforge.pmd.lang.plsql.symboltable.MethodNameDeclaration) {
            sb.append("Method ");
        } else if (declaration instanceof net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration || declaration instanceof VariableNameDeclaration) {
            sb.append("Variable ");
        } else if (declaration instanceof ClassNameDeclaration || declaration instanceof net.sourceforge.pmd.lang.plsql.symboltable.ClassNameDeclaration) {
            sb.append("Class ");
        }
        Class type = declaration.getNode() instanceof TypeNode ? ((TypeNode)declaration.getNode()).getType() : null;
        sb.append(declaration.getName());
        if (type != null) {
            sb.append(" : ").append(type.getSimpleName());
        }
        sb.append(" (l. ").append(declaration.getNode().getBeginLine()).append(")");
        return sb.toString();
    }
}

