/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.codearea;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.CustomCodeArea;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.StyleLayer;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;

class StyleContext
implements Iterable<StyleLayer> {
    private final CustomCodeArea codeArea;
    private Map<String, StyleLayer> layersById = new HashMap<String, StyleLayer>();

    StyleContext(CustomCodeArea codeArea) {
        this.codeArea = codeArea;
    }

    public void addLayer(String id, StyleLayer layer) {
        this.layersById.put(id, layer);
    }

    public StyleLayer getLayer(String id) {
        return this.layersById.get(id);
    }

    public void clearLayer(String id) {
        StyleLayer layer = this.layersById.get(id);
        if (layer != null) {
            layer.clearStyles();
        }
    }

    public void dropLayer(String id) {
        this.layersById.remove(id);
    }

    public StyleSpans<Collection<String>> getStyleSpans() {
        List allSpans = this.layersById.values().stream().filter(Objects::nonNull).map(StyleLayer::getSpans).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        if (allSpans.isEmpty()) {
            return new StyleSpansBuilder().add(Collections.emptySet(), this.codeArea.getLength()).create();
        }
        StyleSpans base = (StyleSpans)allSpans.get(0);
        return allSpans.stream().filter(spans -> spans != base).filter(spans -> spans.length() <= this.codeArea.getLength()).reduce((StyleSpans)allSpans.get(0), (accumulator, elt) -> accumulator.overlay(elt, (style1, style2) -> {
            HashSet styles = new HashSet(style1);
            styles.addAll(style2);
            return styles;
        }));
    }

    @Override
    public Iterator<StyleLayer> iterator() {
        return this.layersById.values().iterator();
    }
}

