/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.util.StringConverter;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.Parser;

public final class DesignerUtil {
    private static final Path PMD_SETTINGS_DIR = Paths.get(System.getProperty("user.home"), ".pmd");
    private static final File DESIGNER_SETTINGS_FILE = PMD_SETTINGS_DIR.resolve("designer.xml").toFile();
    private static final Pattern JJT_ACCEPT_PATTERN = Pattern.compile("net.sourceforge.pmd.lang.\\w++.ast.AST(\\w+).jjtAccept");
    private static List<LanguageVersion> supportedLanguageVersions;
    private static Map<String, LanguageVersion> extensionsToLanguage;

    private DesignerUtil() {
    }

    public static String defaultXPathVersion() {
        return "2.0";
    }

    public static LanguageVersion defaultLanguageVersion() {
        return LanguageRegistry.getDefaultLanguage().getDefaultVersion();
    }

    public static URL getFxml(String simpleName) {
        return DesignerUtil.class.getResource("/net/sourceforge/pmd/util/fxdesigner/fxml/" + simpleName);
    }

    public static File getSettingsFile() {
        return DESIGNER_SETTINGS_FILE;
    }

    public static <T> StringConverter<T> stringConverter(final Function<T, String> toString, final Function<String, T> fromString) {
        return new StringConverter<T>(){

            public String toString(T object) {
                return (String)toString.apply(object);
            }

            public T fromString(String string) {
                return fromString.apply(string);
            }
        };
    }

    public static StringConverter<LanguageVersion> languageVersionStringConverter() {
        return DesignerUtil.stringConverter(LanguageVersion::getShortName, s -> LanguageRegistry.findLanguageVersionByTerseName((String)s.toLowerCase(Locale.ROOT)));
    }

    private static Map<String, LanguageVersion> getExtensionsToLanguageMap() {
        HashMap<String, LanguageVersion> result = new HashMap<String, LanguageVersion>();
        DesignerUtil.getSupportedLanguageVersions().stream().map(LanguageVersion::getLanguage).distinct().collect(Collectors.toMap(Language::getExtensions, Language::getDefaultVersion)).forEach((key, value) -> key.forEach(ext -> result.put((String)ext, (LanguageVersion)value)));
        return result;
    }

    public static synchronized LanguageVersion getLanguageVersionFromExtension(String filename) {
        if (extensionsToLanguage == null) {
            extensionsToLanguage = DesignerUtil.getExtensionsToLanguageMap();
        }
        if (filename.indexOf(46) > 0) {
            String[] tokens = filename.split("\\.");
            return extensionsToLanguage.get(tokens[tokens.length - 1]);
        }
        return null;
    }

    public static synchronized List<LanguageVersion> getSupportedLanguageVersions() {
        if (supportedLanguageVersions == null) {
            ArrayList<LanguageVersion> languageVersions = new ArrayList<LanguageVersion>();
            for (LanguageVersion languageVersion : LanguageRegistry.findAllVersions()) {
                Optional.ofNullable(languageVersion.getLanguageVersionHandler()).map(handler -> handler.getParser(handler.getDefaultParserOptions())).filter(Parser::canParse).ifPresent(p -> languageVersions.add(languageVersion));
            }
            supportedLanguageVersions = languageVersions;
        }
        return supportedLanguageVersions;
    }

    public static <T> void rewire(Property<T> underlying, ObservableValue<? extends T> ui, Consumer<? super T> setter) {
        setter.accept(underlying.getValue());
        underlying.unbind();
        underlying.bind(ui);
    }

    public static <T> void rewire(Property<T> underlying, ObservableValue<? extends T> source) {
        underlying.unbind();
        underlying.bind(source);
    }

    public static Optional<String> stackTraceToXPath(String stackTrace) {
        List lines = Arrays.stream(stackTrace.split("\\n")).map(JJT_ACCEPT_PATTERN::matcher).filter(Matcher::find).map(m -> m.group(1)).collect(Collectors.toList());
        Collections.reverse(lines);
        return lines.isEmpty() ? Optional.empty() : Optional.of("//" + String.join((CharSequence)"/", lines));
    }
}

