/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.model;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.metrics.ApexMetrics;
import net.sourceforge.pmd.lang.apex.metrics.api.ApexClassMetricKey;
import net.sourceforge.pmd.lang.apex.metrics.api.ApexOperationMetricKey;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.metrics.api.JavaClassMetricKey;
import net.sourceforge.pmd.lang.java.metrics.api.JavaOperationMetricKey;
import net.sourceforge.pmd.lang.metrics.MetricKey;
import net.sourceforge.pmd.util.fxdesigner.model.MetricResult;

public class MetricEvaluator {
    public List<MetricResult> evaluateAllMetrics(Node node) throws UnsupportedOperationException {
        if (ASTAnyTypeDeclaration.class.isInstance(node)) {
            return this.evaluateAllMetrics((ASTAnyTypeDeclaration)node);
        }
        if (ASTMethodOrConstructorDeclaration.class.isInstance(node)) {
            return this.evaluateAllMetrics((ASTMethodOrConstructorDeclaration)node);
        }
        if (ASTMethod.class.isInstance(node)) {
            return this.evaluateAllMetrics((ASTMethod)node);
        }
        if (ASTUserClass.class.isInstance(node)) {
            return this.evaluateAllMetrics((ASTUserClass)node);
        }
        throw new UnsupportedOperationException("That language does not support metrics");
    }

    private List<MetricResult> evaluateAllMetrics(ASTMethodOrConstructorDeclaration node) {
        ArrayList<MetricResult> metricResults = new ArrayList<MetricResult>();
        for (JavaOperationMetricKey key : JavaOperationMetricKey.values()) {
            metricResults.add(new MetricResult((MetricKey<?>)key, JavaMetrics.get((MetricKey)key, (ASTMethodOrConstructorDeclaration)node)));
        }
        return metricResults;
    }

    private List<MetricResult> evaluateAllMetrics(ASTAnyTypeDeclaration node) {
        ArrayList<MetricResult> metricResults = new ArrayList<MetricResult>();
        for (JavaClassMetricKey key : JavaClassMetricKey.values()) {
            metricResults.add(new MetricResult((MetricKey<?>)key, JavaMetrics.get((MetricKey)key, (ASTAnyTypeDeclaration)node)));
        }
        return metricResults;
    }

    private List<MetricResult> evaluateAllMetrics(ASTMethod node) {
        ArrayList<MetricResult> metricResults = new ArrayList<MetricResult>();
        for (ApexOperationMetricKey key : ApexOperationMetricKey.values()) {
            metricResults.add(new MetricResult((MetricKey<?>)key, ApexMetrics.get((MetricKey)key, (ASTMethod)node)));
        }
        return metricResults;
    }

    private List<MetricResult> evaluateAllMetrics(ASTUserClass node) {
        ArrayList<MetricResult> metricResults = new ArrayList<MetricResult>();
        for (ApexClassMetricKey key : ApexClassMetricKey.values()) {
            metricResults.add(new MetricResult((MetricKey<?>)key, ApexMetrics.get((MetricKey)key, (ASTUserClass)node)));
        }
        return metricResults;
    }
}

