/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.errors;

import apex.common.base.MoreStrings;
import apex.jorje.data.errors.LexicalError;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import java.util.Collection;

public class LexicalErrorPrinter
implements Printer<LexicalError> {
    private static final LexicalErrorPrinter INSTANCE = new LexicalErrorPrinter();
    private static final String TIME_STRING = I18nSupport.getLabel("time.string");
    private static final String DATE_STRING = I18nSupport.getLabel("date.string");
    private static final LexicalError.MatchBlock<String> MATCHER = new LexicalError.MatchBlock<String>(){

        @Override
        public String _case(LexicalError.UnexpectedLexicalError x) {
            return I18nSupport.getLabel("unexpected.syntax.error", x.message);
        }

        @Override
        public String _case(LexicalError.UnrecognizedSymbol x) {
            return I18nSupport.getLabel("unrecognized.symbol.not.valid.apex.identifier", x.symbol);
        }

        @Override
        public String _case(LexicalError.UnexpectedSymbol x) {
            return I18nSupport.getLabel("unexpected.symbol.expected.found", x.found, x.expected);
        }

        @Override
        public String _case(LexicalError.SymbolNotInExpectedSet x) {
            return I18nSupport.getLabel("unexpected.symbol.set", x.found, LexicalErrorPrinter.join(x.expected));
        }

        @Override
        public String _case(LexicalError.SymbolInUnexpectedSet x) {
            return I18nSupport.getLabel("unexpected.symbol.not.set", x.found, LexicalErrorPrinter.join(x.unexpected));
        }

        @Override
        public String _case(LexicalError.SymbolNotInRange x) {
            return I18nSupport.getLabel("unexpected.symbol.range", x.found, x.begin, x.end);
        }

        @Override
        public String _case(LexicalError.UnterminatedString x) {
            return I18nSupport.getLabel("missing.closing.quote", x.quote);
        }

        @Override
        public String _case(LexicalError.UnterminatedComment x) {
            return I18nSupport.getLabel("missing.closing.mark", x.closeComment);
        }

        @Override
        public String _case(LexicalError.InvalidIdentifier x) {
            return I18nSupport.getLabel("invalid.apex.identifier", x.identifier);
        }

        @Override
        public String _case(LexicalError.InvalidControlChar x) {
            return I18nSupport.getLabel("invalid.control.character", String.format("%04X", x.character), x.character);
        }

        @Override
        public String _case(LexicalError.InvalidSymbol x) {
            return I18nSupport.getLabel("invalid.apex.symbol", Character.valueOf(x.symbol));
        }

        @Override
        public String _case(LexicalError.InvalidTime x) {
            return I18nSupport.getLabel("invalid.time", x.time, TIME_STRING);
        }

        @Override
        public String _case(LexicalError.InvalidDate x) {
            return I18nSupport.getLabel("invalid.date", x.date, DATE_STRING);
        }

        @Override
        public String _case(LexicalError.InvalidDateTime x) {
            return I18nSupport.getLabel("invalid.date.time", x.dateTime, DATE_STRING, TIME_STRING);
        }
    };

    private LexicalErrorPrinter() {
    }

    private static String join(Collection<String> elements) {
        return elements.stream().collect(MoreStrings.ON_COMMA_AND_SPACE);
    }

    public static Printer<LexicalError> get() {
        return INSTANCE;
    }

    @Override
    public String print(LexicalError x, PrintContext ctx) {
        return x.match(MATCHER);
    }
}

