/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.Case;
import apex.jorje.data.ast.CatchBlock;
import apex.jorje.data.ast.ElseBlock;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.FinallyBlock;
import apex.jorje.data.ast.IfBlock;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.soql.FieldIdentifier;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.ast.OptionalPrinter;
import java.util.List;
import java.util.Optional;

public class StmntPrinter
implements Printer<Stmnt> {
    private final String indent;
    private final PrinterFactory factory;

    public StmntPrinter(PrinterFactory factory) {
        this.indent = factory.indent();
        this.factory = factory;
    }

    @Override
    public String print(Stmnt x, final PrintContext ctx) {
        return x.match(new Stmnt.MatchBlock<String>(){

            @Override
            public String _case(Stmnt.BlockStmnt x) {
                return StmntPrinter.this.indent + StmntPrinter.this.factory.optionalNestedStmntPrinter().print(Optional.of(x), ctx);
            }

            @Override
            public String _case(Stmnt.ExpressionStmnt x) {
                return StmntPrinter.this.indent + StmntPrinter.this.factory.exprPrinter().print(x.expr, ctx) + ";";
            }

            @Override
            public String _case(Stmnt.ReturnStmnt x) {
                Printer<Optional<Expr>> optionalExpr = OptionalPrinter.create(StmntPrinter.this.factory.exprPrinter(), "", " ", "");
                return StmntPrinter.this.indent + "return" + optionalExpr.print(x.expr, ctx) + ";";
            }

            @Override
            public String _case(Stmnt.ThrowStmnt x) {
                return StmntPrinter.this.indent + "throw " + StmntPrinter.this.factory.exprPrinter().print(x.expr, ctx) + ";";
            }

            @Override
            public String _case(Stmnt.BreakStmnt x) {
                return StmntPrinter.this.indent + "break;";
            }

            @Override
            public String _case(Stmnt.ContinueStmnt x) {
                return StmntPrinter.this.indent + "continue;";
            }

            @Override
            public String _case(Stmnt.DmlInsertStmnt x) {
                return StmntPrinter.this.indent + "insert " + StmntPrinter.this.factory.exprPrinter().print(x.expr, ctx) + ";";
            }

            @Override
            public String _case(Stmnt.DmlUpdateStmnt x) {
                return StmntPrinter.this.indent + "update " + StmntPrinter.this.factory.exprPrinter().print(x.expr, ctx) + ";";
            }

            @Override
            public String _case(Stmnt.DmlUpsertStmnt x) {
                Printer<Optional<FieldIdentifier>> optionalExpr = OptionalPrinter.create(StmntPrinter.this.factory.fieldIdentifierPrinter(), "", "", "");
                return StmntPrinter.this.indent + "upsert " + StmntPrinter.this.factory.exprPrinter().print(x.expr, ctx) + optionalExpr.print(x.id, ctx) + ";";
            }

            @Override
            public String _case(Stmnt.DmlDeleteStmnt x) {
                return StmntPrinter.this.indent + "delete " + StmntPrinter.this.factory.exprPrinter().print(x.expr, ctx) + ";";
            }

            @Override
            public String _case(Stmnt.DmlUndeleteStmnt x) {
                return StmntPrinter.this.indent + "undelete " + StmntPrinter.this.factory.exprPrinter().print(x.expr, ctx) + ";";
            }

            @Override
            public String _case(Stmnt.DmlMergeStmnt x) {
                return StmntPrinter.this.indent + "merge " + StmntPrinter.this.factory.exprPrinter().print(x.expr1, ctx) + " " + StmntPrinter.this.factory.exprPrinter().print(x.expr2, ctx) + ";";
            }

            @Override
            public String _case(Stmnt.WhileLoop x) {
                return StmntPrinter.this.indent + "while(" + StmntPrinter.this.factory.exprPrinter().print(x.condition, ctx) + ") " + StmntPrinter.this.factory.optionalNestedStmntPrinter().print(x.stmnt, ctx);
            }

            @Override
            public String _case(Stmnt.DoLoop x) {
                return StmntPrinter.this.indent + "do\n" + StmntPrinter.this.print(x.stmnt, ctx) + "while(" + StmntPrinter.this.factory.exprPrinter().print(x.condition, ctx) + ")";
            }

            @Override
            public String _case(Stmnt.IfElseBlock x) {
                Printer<List<IfBlock>> ifBlockListPrinter = ListPrinter.create(StmntPrinter.this.factory.ifBlockPrinter(), "else if ", "if ", "");
                Printer<Optional<ElseBlock>> optionalElseBlock = OptionalPrinter.create(StmntPrinter.this.factory.elseBlockPrinter(), "", "", "");
                return StmntPrinter.this.indent + ifBlockListPrinter.print(x.ifBlocks, ctx) + optionalElseBlock.print(x.elseBlock, ctx);
            }

            @Override
            public String _case(Stmnt.RunAsBlock x) {
                return StmntPrinter.this.indent + "system.runas(" + StmntPrinter.this.factory.exprListPrinter().print(x.inputParameters, ctx) + ")" + StmntPrinter.this.factory.optionalNestedStmntPrinter().print(Optional.of(x.stmnt), ctx);
            }

            @Override
            public String _case(Stmnt.TryCatchFinallyBlock x) {
                Printer<List<CatchBlock>> catchBlockListPrinter = ListPrinter.create(StmntPrinter.this.factory.catchBlockPrinter(), "catch ", "catch ", "");
                Printer<Optional<FinallyBlock>> optionalFinallyBlock = OptionalPrinter.create(StmntPrinter.this.factory.finallyBlockPrinter(), "", "", "");
                return StmntPrinter.this.indent + "try " + StmntPrinter.this.factory.optionalNestedStmntPrinter().print(Optional.of(x.tryBlock), ctx) + catchBlockListPrinter.print(x.catchBlocks, ctx) + optionalFinallyBlock.print(x.finallyBlock, ctx);
            }

            @Override
            public String _case(Stmnt.VariableDeclStmnt x) {
                return StmntPrinter.this.factory.variableDeclsPrinter().print(x.variableDecls, ctx);
            }

            @Override
            public String _case(Stmnt.ForLoop x) {
                return StmntPrinter.this.indent + "for (" + StmntPrinter.this.factory.forControlPrinter().print(x.forControl, ctx) + ") " + StmntPrinter.this.factory.optionalNestedStmntPrinter().print(x.stmnt, ctx);
            }

            @Override
            public String _case(Stmnt.SwitchStatement x) {
                Printer<List<Case>> caseListPrinter = ListPrinter.create(StmntPrinter.this.factory.casePrinter(), "\n", "", "");
                return StmntPrinter.this.indent + "switch on {\n" + caseListPrinter.print(x.cases, ctx) + "}";
            }
        });
    }
}

