/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.common.base.MoreStrings;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.NameValueParameter;
import apex.jorje.data.ast.NewObject;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.ast.OptionalPrinter;
import java.util.List;
import java.util.Optional;

public class NewObjectPrinter
implements Printer<NewObject> {
    private final PrinterFactory factory;
    private final Printer<Expr> exprPrinter;
    private final Printer<TypeRef> typeRefPrinter;
    private final Printer<Optional<Expr>> optionalExpr;
    private final Printer<List<TypeRef>> typeListPrinter;
    private final Printer<List<NameValueParameter>> sObjectParameterListPrinter;

    public NewObjectPrinter(PrinterFactory factory) {
        this.factory = factory;
        this.exprPrinter = factory.exprPrinter();
        this.typeRefPrinter = factory.typeRefPrinter();
        this.optionalExpr = OptionalPrinter.create(this.exprPrinter, "", "", "");
        this.typeListPrinter = ListPrinter.create(this.typeRefPrinter, ", ", "<", ">");
        this.sObjectParameterListPrinter = ListPrinter.create(factory.nameValueParameter(), ", ", "(", ")");
    }

    @Override
    public String print(NewObject x, final PrintContext ctx) {
        return x.match(new NewObject.MatchBlock<String>(){

            @Override
            public String _case(NewObject.NewListInit x) {
                return "List" + NewObjectPrinter.this.typeListPrinter.print(x.types, ctx) + "(" + NewObjectPrinter.this.optionalExpr.print(x.expr, ctx) + ")";
            }

            @Override
            public String _case(NewObject.NewListLiteral x) {
                return "List" + NewObjectPrinter.this.typeListPrinter.print(x.types, ctx) + "{" + NewObjectPrinter.this.factory.exprListPrinter().print(x.values, ctx) + "}";
            }

            @Override
            public String _case(NewObject.NewSetInit x) {
                return "Set" + NewObjectPrinter.this.typeListPrinter.print(x.types, ctx) + "(" + NewObjectPrinter.this.optionalExpr.print(x.expr, ctx) + ")";
            }

            @Override
            public String _case(NewObject.NewSetLiteral x) {
                return "Set" + NewObjectPrinter.this.typeListPrinter.print(x.types, ctx) + "{" + NewObjectPrinter.this.factory.exprListPrinter().print(x.values, ctx) + "}";
            }

            @Override
            public String _case(NewObject.NewMapInit x) {
                return "Map" + NewObjectPrinter.this.typeListPrinter.print(x.types, ctx) + "(" + NewObjectPrinter.this.optionalExpr.print(x.expr, ctx) + ")";
            }

            @Override
            public String _case(NewObject.NewMapLiteral x) {
                return "Map" + NewObjectPrinter.this.typeListPrinter.print(x.types, ctx) + x.pairs.stream().map(keyValue -> NewObjectPrinter.this.exprPrinter.print(keyValue.key, ctx) + " => " + NewObjectPrinter.this.exprPrinter.print(keyValue.value, ctx)).collect(MoreStrings.ON_COMMA_ENCLOSING_CURLY_BRACES);
            }

            @Override
            public String _case(NewObject.NewKeyValue x) {
                return NewObjectPrinter.this.typeRefPrinter.print(x.type, ctx) + NewObjectPrinter.this.sObjectParameterListPrinter.print(x.keyValues, ctx);
            }

            @Override
            public String _case(NewObject.NewStandard x) {
                return NewObjectPrinter.this.typeRefPrinter.print(x.type, ctx) + "(" + NewObjectPrinter.this.factory.exprListPrinter().print(x.inputParameters, ctx) + ")";
            }
        });
    }
}

