/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.semantic.common.iterable.SuperTypeIterable;
import apex.jorje.semantic.exception.SemanticException;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.semantic.symbol.type.parent.DuplicateGenericInterfaceCalculator;
import apex.jorje.semantic.symbol.type.parent.ParentTypeResolver;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.exception.CompilationException;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreLists;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ParentTableCalculator {
    static final int MAX_EXTENDS_DEPTH = 10;
    private static final Set<Equivalence.Wrapper<TypeInfo>> ILLEGAL_EXPLICIT_EXTEND_TYPES = ImmutableSet.of(InternalTypeInfos.APEX_OBJECT.getEquivalenceWrapper(), TypeInfos.OBJECT.getEquivalenceWrapper(), InternalTypeInfos.ENUM.getEquivalenceWrapper());
    private static final Set<Equivalence.Wrapper<TypeInfo>> TRUSTED_ONLY_EXPLICIT_EXTEND_TYPES = ImmutableSet.of(InternalTypeInfos.APEX_EXCEPTION.getEquivalenceWrapper());
    private final Multimap<TypeInfo, CompilationException> errors;
    private final SymbolResolver symbols;
    private final Set<TypeInfo> visitedSuperTypes;
    private final Set<TypeInfo> visitedInterfaces;
    private final ParentTypeResolver resolver;
    private boolean hasSuperTypeCycle;
    private boolean hasInterfaceCycle;

    ParentTableCalculator(Multimap<TypeInfo, CompilationException> errors, SymbolResolver symbols) {
        this.errors = errors;
        this.symbols = symbols;
        this.resolver = new ParentTypeResolver(errors, symbols);
        this.visitedSuperTypes = new HashSet<TypeInfo>();
        this.visitedInterfaces = new HashSet<TypeInfo>();
        this.hasSuperTypeCycle = false;
        this.hasInterfaceCycle = false;
    }

    private boolean isExplicitExtend(TypeInfo type) {
        return type.getCodeUnitDetails().getSuperTypeRef().isPresent();
    }

    private boolean isIllegalExplicitExtendType(TypeInfo superType, boolean isTrustedSource) {
        return ILLEGAL_EXPLICIT_EXTEND_TYPES.contains(superType.getEquivalenceWrapper()) || !isTrustedSource && TRUSTED_ONLY_EXPLICIT_EXTEND_TYPES.contains(superType.getEquivalenceWrapper());
    }

    void resolveSuperTypes(TypeInfo type) {
        if (this.visitedSuperTypes.contains(type)) {
            this.hasSuperTypeCycle = true;
            return;
        }
        this.visitedSuperTypes.add(type);
        if (type.parents().areSuperTypesResolved()) {
            return;
        }
        if (this.errors.containsKey(type)) {
            type.parents().resolveSuperTypes(TypeInfos.OBJECT);
            return;
        }
        TypeInfo superType = this.resolver.getSuperType(type);
        TypeInfo actualSuperType = TypeInfoEquivalence.isEquivalent(superType, TypeInfos.EXCEPTION) && !TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.APEX_EXCEPTION) ? this.symbols.lookupTypeInfo(type, InternalTypeInfos.APEX_EXCEPTION) : (type.getUnitType() == UnitType.CLASS && TypeInfoEquivalence.isEquivalent(superType, TypeInfos.OBJECT) && !TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.APEX_OBJECT) ? this.symbols.lookupTypeInfo(type, InternalTypeInfos.APEX_OBJECT) : superType);
        boolean isSuperTypeValid = this.resolveParentSuperType(type, actualSuperType);
        if (isSuperTypeValid) {
            if (ExceptionTypeInfoUtil.isException(type, superType) && !TypeNameUtil.isException(type.getApexName())) {
                this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("invalid.exception.must.end.with.exception", type)));
            } else if (type.getUnitType() == UnitType.CLASS && !ExceptionTypeInfoUtil.isException(type, superType) && TypeNameUtil.isException(type.getApexName())) {
                this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("invalid.exception.must.extend.exception", superType)));
            } else {
                boolean isIllegalExtend;
                boolean bl = isIllegalExtend = superType.getModifiers().none(ModifierTypeInfos.ABSTRACT, ModifierTypeInfos.VIRTUAL) && superType.getUnitType() != UnitType.INTERFACE && !TypeInfoUtil.isInnerTypeOfAnonymous(superType) && !TypeInfoUtil.isInnerTypeOfTrigger(superType) && !type.getCodeUnitDetails().isMocked();
                if (isIllegalExtend || this.isExplicitExtend(type) && this.isIllegalExplicitExtendType(superType, type.getCodeUnitDetails().isFileBased())) {
                    this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("invalid.final.super.type", superType)));
                }
            }
        }
        if (isSuperTypeValid && !this.errors.containsKey(type)) {
            type.parents().resolveSuperTypes(actualSuperType);
            this.validateSuperTypeDepth(type);
            if (TypeInfoUtil.isInnerType(actualSuperType) && !actualSuperType.getEnclosingType().parents().areSuperTypesResolved()) {
                this.resolveSuperTypes(actualSuperType.getEnclosingType());
            }
        } else {
            ScalarTypeInfo validSuperType = actualSuperType.isResolved() && actualSuperType.parents().areSuperTypesResolved() ? actualSuperType : TypeInfos.OBJECT;
            type.parents().resolveSuperTypes(validSuperType);
        }
    }

    void resolveInterfaces(TypeInfo type) {
        if (this.visitedInterfaces.contains(type)) {
            this.hasInterfaceCycle = true;
            return;
        }
        this.visitedInterfaces.add(type);
        if (type.parents().areInterfacesResolved()) {
            return;
        }
        if (!type.parents().areSuperTypesResolved()) {
            this.resolveSuperTypes(type);
        }
        if (type.parents().superType() != null && !type.parents().superType().parents().areInterfacesResolved()) {
            this.resolveInterfaces(type.parents().superType());
        }
        if (this.errors.containsKey(type)) {
            type.parents().resolveInterfaces(ImmutableList.of());
            return;
        }
        List<TypeInfo> interfaces = this.resolver.getInterfaceTypes(type);
        boolean areInterfacesValid = true;
        for (TypeInfo interfaceType2 : interfaces) {
            areInterfacesValid &= this.resolveInterfaces(type, interfaceType2);
            if (!this.requiresTopLevelType(type, interfaceType2)) continue;
            this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("type.must.be.top.level", interfaceType2)));
        }
        if (areInterfacesValid && !this.errors.containsKey(type)) {
            type.parents().resolveInterfaces(interfaces);
            DuplicateGenericInterfaceCalculator.calculate(type, this.errors);
        } else {
            List<TypeInfo> validInterfaces = interfaces.stream().filter(interfaceType -> interfaceType.isResolved() && interfaceType.parents().areInterfacesResolved()).collect(MoreLists.toImmutableList(interfaces.size()));
            type.parents().resolveInterfaces(validInterfaces);
        }
    }

    private boolean requiresTopLevelType(TypeInfo type, TypeInfo interfaceType) {
        TypeInfo rootInterfaceType = GenericTypeInfoUtil.getRootType(interfaceType);
        return TypeInfoUtil.isInnerType(type) && (TypeInfoEquivalence.isEquivalent(rootInterfaceType, InternalTypeInfos.DATABASE_BATCHABLE) || TypeInfoEquivalence.isEquivalent(rootInterfaceType, InternalTypeInfos.MESSAGING_INBOUND_EMAIL_HANDLER));
    }

    private void validateSuperTypeDepth(TypeInfo type) {
        int superTypeCount = -3;
        for (TypeInfo ignored : new SuperTypeIterable(type)) {
            ++superTypeCount;
        }
        if (superTypeCount > 10) {
            this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("maximum.type.depth.exceeded")));
        }
    }

    private boolean resolveParentSuperType(TypeInfo type, TypeInfo parentType) {
        if (parentType == null) {
            return true;
        }
        if (!parentType.isResolved()) {
            return false;
        }
        TypeInfo rawSuperType = GenericTypeInfoUtil.getRootType(parentType);
        if (!rawSuperType.parents().areSuperTypesResolved()) {
            this.resolveSuperTypes(rawSuperType);
            if (this.hasSuperTypeCycle) {
                this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("circular.definition", parentType)));
                return false;
            }
            if (!rawSuperType.parents().areSuperTypesResolved()) {
                this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("invalid.super.type", parentType)));
                return false;
            }
        }
        return true;
    }

    private boolean resolveInterfaces(TypeInfo type, TypeInfo interfaceType) {
        if (!interfaceType.isResolved()) {
            return false;
        }
        TypeInfo rawInterfaceType = GenericTypeInfoUtil.getRootType(interfaceType);
        if (!rawInterfaceType.parents().areInterfacesResolved()) {
            this.resolveInterfaces(rawInterfaceType);
            if (this.hasInterfaceCycle) {
                this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("circular.definition", interfaceType)));
                return false;
            }
            if (!rawInterfaceType.parents().areInterfacesResolved()) {
                this.errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("invalid.interface", interfaceType)));
                return false;
            }
        }
        return true;
    }
}

