/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.naming;

import apex.common.base.ObjectHash;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TypeNameParser {
    private static final CharMatcher IDENTIFIER = CharMatcher.DIGIT.or(CharMatcher.is('/')).or(CharMatcher.is('_')).or(CharMatcher.is('.')).or(CharMatcher.is('$')).or(CharMatcher.inRange('a', 'z')).or(CharMatcher.inRange('A', 'Z'));
    private final String typeName;
    private final String separator;
    private final String left;
    private final String right;
    private final Splitter splitter;
    private int depth;
    private int index = 0;

    private TypeNameParser(String typeName, Splitter splitter, String separator, String left, String right) {
        this.typeName = typeName;
        this.splitter = splitter;
        this.depth = 0;
        this.separator = separator;
        this.left = left;
        this.right = right;
    }

    @SfdcCalled
    public static TypeName parseBytecodeName(String bytecodeName) {
        return new TypeNameParser(bytecodeName, BytecodeNameSplitter.INSTANCE, "$$c", "$$l", "$$r").parse();
    }

    @SfdcCalled
    public static TypeName parseApexName(String apexName) {
        return new TypeNameParser(apexName, ApexNameSplitter.INSTANCE, ",", "<", ">").parse();
    }

    private String identifier() {
        StringBuilder builder = new StringBuilder();
        while (this.index < this.typeName.length() && IDENTIFIER.matches(this.typeName.charAt(this.index)) && !this.isDelimiter(this.left) && !this.isDelimiter(this.right) && !this.isDelimiter(this.separator)) {
            builder.append(this.typeName.charAt(this.index));
            ++this.index;
        }
        return builder.toString();
    }

    private boolean isDelimiter(String delimiter) {
        return this.typeName.regionMatches(this.index, delimiter, 0, delimiter.length());
    }

    private TypeName parse() {
        ImmutableList.Builder typeArguments = ImmutableList.builder();
        String typeName = this.identifier();
        TypeName.Info info = this.splitter.split(typeName);
        boolean currentTypeArguments = false;
        while (this.index < this.typeName.length()) {
            if (this.isDelimiter(this.left)) {
                this.index += this.left.length();
                currentTypeArguments = true;
                ++this.depth;
                typeArguments.add(this.parse());
                continue;
            }
            if (this.isDelimiter(this.right)) {
                if (currentTypeArguments) {
                    this.index += this.right.length();
                    break;
                }
                if (this.depth > 0) {
                    --this.depth;
                    break;
                }
                throw new IllegalArgumentException("Invalid type name: " + this.typeName);
            }
            if (this.isDelimiter(this.separator)) {
                if (currentTypeArguments) {
                    this.index += this.separator.length();
                    typeArguments.add(this.parse());
                    continue;
                }
                if (this.depth > 0) break;
                throw new IllegalArgumentException("Invalid type name: " + this.typeName);
            }
            throw new IllegalArgumentException("Invalid type name: " + this.typeName);
        }
        return new TypeName(info, typeName, (List)((Object)typeArguments.build()));
    }

    private static class ApexNameSplitter
    implements Splitter {
        private static final Splitter INSTANCE = new ApexNameSplitter();
        private static final Pattern APEX_NAME = Pattern.compile("((\\w+)\\.)?((\\w+)\\.)?(\\w+)");

        private ApexNameSplitter() {
        }

        @Override
        public TypeName.Info split(String value) {
            Matcher matcher = APEX_NAME.matcher(value);
            if (matcher.find()) {
                String namespace = MoreObjects.firstNonNull(matcher.group(2), "");
                return new TypeName.Info(namespace, matcher.group(4), matcher.group(5));
            }
            return null;
        }
    }

    private static class BytecodeNameSplitter
    implements Splitter {
        private static final Splitter INSTANCE = new BytecodeNameSplitter();

        private BytecodeNameSplitter() {
        }

        private String nextString(String value, char delimiter, int offset) {
            int index = value.indexOf(delimiter, offset);
            return index != -1 ? value.substring(offset, index) : "";
        }

        @Override
        public TypeName.Info split(String value) {
            String enclosingName;
            String nextNamespace;
            assert (!Strings.isNullOrEmpty(value)) : "asked to parse an empty name";
            int offset = 0;
            String namespace = this.nextString(value, '/', offset);
            if (!namespace.isEmpty() && !(nextNamespace = this.nextString(value, '/', offset += namespace.length() + 1)).isEmpty()) {
                namespace = nextNamespace;
                offset += namespace.length() + 1;
            }
            if (!(enclosingName = this.nextString(value, '$', offset)).isEmpty()) {
                offset += enclosingName.length() + 1;
            } else {
                enclosingName = null;
            }
            String typeName = value.substring(offset);
            return new TypeName.Info(namespace, enclosingName, typeName);
        }
    }

    public static class TypeName {
        private final Info info;
        private final String name;
        private final List<TypeName> arguments;

        @VisibleForTesting
        public TypeName(String name, TypeName ... arguments) {
            this(null, name, MoreLists.asImmutableList(arguments));
        }

        private TypeName(Info info, String name, List<TypeName> arguments) {
            this.info = info;
            this.name = name;
            this.arguments = arguments;
        }

        public int hashCode() {
            return ObjectHash.hash(this.name, this.arguments);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeName typeName = (TypeName)o;
            return Objects.equals(this.name, typeName.name) && Objects.equals(this.arguments, typeName.arguments);
        }

        public String toString() {
            return TypeNameUtil.createBytecodeName(this.name, this.arguments.stream().map(Object::toString).collect(Collectors.toList()));
        }

        public Info getInfo() {
            return this.info;
        }

        public String getName() {
            return this.name;
        }

        public List<TypeName> getArguments() {
            return this.arguments;
        }

        public static class Info {
            private final String namespace;
            private final String enclosingName;
            private final String className;

            private Info(String namespace, String enclosingName, String className) {
                this.namespace = namespace;
                this.enclosingName = enclosingName;
                this.className = className;
            }

            public String getTopLevelName() {
                return MoreObjects.firstNonNull(this.enclosingName, this.className);
            }

            public String getNamespace() {
                return this.namespace;
            }

            public String getEnclosingName() {
                return this.enclosingName;
            }

            public String getClassName() {
                return this.className;
            }
        }
    }

    private static interface Splitter {
        public TypeName.Info split(String var1);
    }
}

