/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.details;

import apex.common.base.Initializer;
import apex.common.tuple.IntPair;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.OldVersionProvider;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.compiler.StructuredVersionRange;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.details.InterfaceTypeRefsMatcher;
import apex.jorje.semantic.symbol.type.details.NameMatcher;
import apex.jorje.semantic.symbol.type.details.SuperTypeRefMatcher;
import apex.jorje.semantic.symbol.type.details.TriggerTargetTypeMatcher;
import apex.jorje.semantic.symbol.type.reference.TypeReference;
import apex.jorje.services.Version;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class CodeUnitDetailsProvider {
    public static final Initializer<CodeUnitDetails, TypeInfo> NONE = NonSourceCodeUnitDetails::new;

    private CodeUnitDetailsProvider() {
    }

    public static boolean isUserSourced(CodeUnitDetails details) {
        return details.isApexSourceBased() && !details.isFileBased();
    }

    public static class NonSourceCodeUnitDetails
    implements CodeUnitDetails {
        private final TypeInfo type;

        public NonSourceCodeUnitDetails(TypeInfo type) {
            this.type = type;
        }

        @Override
        public boolean isApexSourceBased() {
            return false;
        }

        @Override
        public SourceFile getSource() {
            throw new UnsupportedOperationException("Can't get source for non source code unit");
        }

        @Override
        public String getName() {
            return this.type.getApexName();
        }

        @Override
        public boolean isTrusted() {
            return true;
        }

        @Override
        public boolean isFileBased() {
            return false;
        }

        @Override
        public boolean isMocked() {
            return false;
        }

        @Override
        public OldVersionProvider getVersionProvider() {
            return null;
        }

        @Override
        public Map<Namespace, StructuredVersion> getReferencedPackageVersions() {
            return ImmutableMap.of();
        }

        @Override
        public Map<IntPair, StructuredVersionRange> getExportedPackageVersions() {
            return ImmutableMap.of();
        }

        @Override
        public Map<IntPair, Map<String, StructuredVersion>> getInterfacePackageVersions() {
            return ImmutableMap.of();
        }

        @Override
        public Version getVersion() {
            return Version.CURRENT;
        }

        @Override
        public TypeReference getTriggerType() {
            throw new UnsupportedOperationException("Can't get Trigger Type for non source code unit");
        }

        @Override
        public Optional<TypeRef> getSuperTypeRef() {
            throw new UnsupportedOperationException("Can't get Super Type Ref for non source code unit");
        }

        @Override
        public List<TypeRef> getInterfaceTypeRefs() {
            throw new UnsupportedOperationException("Can't get Interface Type Refs for non source code unit");
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("type", this.type).toString();
        }
    }

    public static class InvalidSourceCodeUnitDetails
    implements CodeUnitDetails {
        private final SourceFile source;

        public InvalidSourceCodeUnitDetails(SourceFile source) {
            assert (!Strings.isNullOrEmpty(source.getKnownName())) : "can NOT use a source with no known name aka something new";
            this.source = source;
        }

        @Override
        public boolean isApexSourceBased() {
            return true;
        }

        @Override
        public SourceFile getSource() {
            return this.source;
        }

        @Override
        public String getName() {
            return this.source.getKnownName();
        }

        @Override
        public Version getVersion() {
            return this.source.getVersion();
        }

        @Override
        public TypeReference getTriggerType() {
            throw new UnsupportedOperationException("Can't get Trigger Type for invalid source code unit");
        }

        @Override
        public Optional<TypeRef> getSuperTypeRef() {
            throw new UnsupportedOperationException("Can't get Super Type Ref for invalid source code unit");
        }

        @Override
        public List<TypeRef> getInterfaceTypeRefs() {
            throw new UnsupportedOperationException("Can't get Interface Type Refs for invalid source code unit");
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("namespace", this.source.getNamespace()).add("name", this.source.getKnownName()).toString();
        }

        @Override
        public boolean isTrusted() {
            return this.source.isTrusted();
        }

        @Override
        public boolean isFileBased() {
            return this.source.isFileBased();
        }

        @Override
        public boolean isMocked() {
            return false;
        }

        @Override
        public OldVersionProvider getVersionProvider() {
            return this.source.getVersionProvider();
        }

        @Override
        public Map<Namespace, StructuredVersion> getReferencedPackageVersions() {
            return this.source.getReferencedPackageVersions();
        }

        @Override
        public Map<IntPair, StructuredVersionRange> getExportedPackageVersions() {
            return this.source.getExportedPackageVersions();
        }

        @Override
        public Map<IntPair, Map<String, StructuredVersion>> getInterfacePackageVersions() {
            return this.source.getInterfacePackageVersions();
        }
    }

    public static class SourceCodeUnitDetails
    implements CodeUnitDetails {
        private final SourceFile source;
        private final String name;
        private final TypeReference triggerType;
        private final Optional<TypeRef> superTypeRef;
        private final List<TypeRef> interfaceTypeRefs;
        private final Location loc;

        public SourceCodeUnitDetails(SourceFile source, CompilationUnit compilationUnit) {
            this.source = source;
            this.name = compilationUnit.match(NameMatcher.get());
            this.triggerType = compilationUnit.match(TriggerTargetTypeMatcher.get());
            this.superTypeRef = compilationUnit.match(SuperTypeRefMatcher.get());
            this.interfaceTypeRefs = compilationUnit.match(InterfaceTypeRefsMatcher.get());
            this.loc = Locations.from(compilationUnit);
        }

        @Override
        public boolean isApexSourceBased() {
            return true;
        }

        @Override
        public Location getLoc() {
            return this.loc;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("namespace", this.source.getNamespace()).add("name", this.name).toString();
        }

        @Override
        public boolean isTrusted() {
            return this.source.isTrusted();
        }

        @Override
        public SourceFile getSource() {
            return this.source;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isFileBased() {
            return this.source.isFileBased();
        }

        @Override
        public boolean isMocked() {
            return this.source.isMocked();
        }

        @Override
        public OldVersionProvider getVersionProvider() {
            return this.source.getVersionProvider();
        }

        @Override
        public Map<Namespace, StructuredVersion> getReferencedPackageVersions() {
            return this.source.getReferencedPackageVersions();
        }

        @Override
        public Map<IntPair, StructuredVersionRange> getExportedPackageVersions() {
            return this.source.getExportedPackageVersions();
        }

        @Override
        public Map<IntPair, Map<String, StructuredVersion>> getInterfacePackageVersions() {
            return this.source.getInterfacePackageVersions();
        }

        @Override
        public Version getVersion() {
            return this.source.getVersion();
        }

        @Override
        public TypeReference getTriggerType() {
            return this.triggerType;
        }

        @Override
        public Optional<TypeRef> getSuperTypeRef() {
            return this.superTypeRef;
        }

        @Override
        public List<TypeRef> getInterfaceTypeRefs() {
            return this.interfaceTypeRefs;
        }
    }
}

