/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.BiPredicates;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;

public class SObjectMetadata {
    private final Set<DmlOperation> supportedDml;
    private final CustomSettingType customSettingType;
    private final boolean isCustomizableSetupEntity;
    private final boolean isEditable;
    private final boolean isPlatformEvent;
    private final boolean isTriggerable;
    private final TypeInfo unionParentType;
    private final BiPredicate<String, TypeInfo> isLookupField;

    private SObjectMetadata(Builder builder) {
        this.supportedDml = builder.supportedDml;
        this.isLookupField = builder.isLookupField;
        this.customSettingType = builder.customSettingType;
        this.isCustomizableSetupEntity = builder.isCustomizableSetupEntity;
        this.isPlatformEvent = builder.isPlatformEvent;
        this.isEditable = builder.isEditable;
        this.isTriggerable = builder.isTriggerable;
        this.unionParentType = builder.unionParentType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<DmlOperation> getSupportedDml() {
        return this.supportedDml;
    }

    public BiPredicate<String, TypeInfo> getIsLookupField() {
        return this.isLookupField;
    }

    public boolean isCustomizableSetupEntity() {
        return this.isCustomizableSetupEntity;
    }

    public boolean isCustomSetting() {
        return this.customSettingType != CustomSettingType.NONE;
    }

    public CustomSettingType getCustomSettingType() {
        return this.customSettingType;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean isTriggerable() {
        return this.isTriggerable;
    }

    public boolean isPlatformEvent() {
        return this.isPlatformEvent;
    }

    public TypeInfo getUnionParentType(TypeInfo type) {
        return Optional.ofNullable(this.unionParentType).orElse(type);
    }

    public static class Builder {
        private Set<DmlOperation> supportedDml = DmlOperation.ALL;
        private BiPredicate<String, TypeInfo> isLookupField = BiPredicates.alwaysFalse();
        private CustomSettingType customSettingType = CustomSettingType.NONE;
        private boolean isCustomizableSetupEntity;
        private boolean isEditable = true;
        private boolean isPlatformEvent = false;
        private boolean isTriggerable = false;
        private TypeInfo unionParentType;

        private Builder() {
        }

        public Builder setSupportedDml(Set<DmlOperation> supportedDml) {
            this.supportedDml = supportedDml.isEmpty() ? DmlOperation.EMPTY : ImmutableSet.copyOf(supportedDml);
            return this;
        }

        public Builder setLookupFieldPredicate(BiPredicate<String, TypeInfo> isLookupField) {
            this.isLookupField = isLookupField;
            return this;
        }

        public Builder setCustomSettingType(CustomSettingType customSettingType) {
            this.customSettingType = customSettingType;
            return this;
        }

        public Builder setCustomizableSetupEntity(boolean isCustomizableSetupEntity) {
            this.isCustomizableSetupEntity = isCustomizableSetupEntity;
            return this;
        }

        public Builder setEditable(boolean isEditable) {
            this.isEditable = isEditable;
            return this;
        }

        public Builder setPlatformEvent(boolean isPlatformEvent) {
            this.isPlatformEvent = isPlatformEvent;
            return this;
        }

        public Builder setTriggerable(boolean isTriggerable) {
            this.isTriggerable = isTriggerable;
            return this;
        }

        public Builder setUnionParent(TypeInfo unionParentType) {
            this.unionParentType = unionParentType;
            return this;
        }

        public SObjectMetadata build() {
            return new SObjectMetadata(this);
        }
    }

    public static enum CustomSettingType {
        LIST,
        HIERARCHY,
        NONE;

    }
}

