/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.common.base.Initializer;
import apex.common.base.Initializers;
import apex.common.base.WeakStringInterner;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.member.variable.MultipleFieldTable;
import apex.jorje.semantic.symbol.member.variable.StandardFieldTable;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.ModifiersMatchBlock;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.details.CodeUnitDetailsProvider;
import apex.jorje.semantic.symbol.type.naming.TypeNameFactory;
import apex.jorje.semantic.symbol.type.naming.TypeNameProvider;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import apex.jorje.semantic.symbol.type.parent.ParentTableFactory;
import apex.jorje.semantic.symbol.type.parent.StandardParentTable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Equivalence;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import java.util.List;

public abstract class AbstractTypeInfo
implements TypeInfo {
    private static final Equivalence<TypeInfo> TYPE_INFO_WRAPPER = new TypeInfoEquivalence();
    private final String apexName;
    private final String bytecodeMethodName;
    private final String bytecodeName;
    private final String typeSignature;
    private final TypeInfo enclosingType;
    private final Namespace namespace;
    private final ModifierGroup modifiers;
    private final BasicType basicType;
    private final UnitType unitType;
    private final boolean resolved;
    private final Initializer<ParentTable, TypeInfo> parents;
    private final Initializer<FieldTable, TypeInfo> fields;
    private final Initializer<MethodTable, TypeInfo> methods;
    private final Initializer<MethodTable, TypeInfo> virtualMethods;
    private final Initializer<CodeUnitDetails, TypeInfo> codeUnit;
    private final Equivalence.Wrapper<TypeInfo> typeComparator;

    public AbstractTypeInfo(Builder<? extends Builder, ? extends AbstractTypeInfo> builder) {
        this.apexName = WeakStringInterner.get().intern(((Builder)builder).apexName);
        this.bytecodeName = WeakStringInterner.get().intern(((Builder)builder).bytecodeName);
        this.bytecodeMethodName = WeakStringInterner.get().intern(MoreObjects.firstNonNull(((Builder)builder).bytecodeMethodName, this.bytecodeName));
        this.typeSignature = WeakStringInterner.get().intern(builder.getTypeSignature());
        this.resolved = ((Builder)builder).resolved;
        this.enclosingType = ((Builder)builder).enclosingType;
        this.namespace = ((Builder)builder).namespace;
        this.modifiers = ((Builder)builder).modifiers;
        this.parents = ((Builder)builder).parents;
        this.methods = ((Builder)builder).methods;
        this.virtualMethods = MoreObjects.firstNonNull(((Builder)builder).virtualMethods, this.methods);
        this.fields = ((Builder)builder).fields;
        this.unitType = ((Builder)builder).unitType;
        this.basicType = ((Builder)builder).basicType;
        this.codeUnit = ((Builder)builder).codeUnit;
        this.typeComparator = TYPE_INFO_WRAPPER.wrap(this);
        assert (this.apexName != null) : "no apex name defined";
        assert (this.bytecodeName != null) : "no bytecode name defined";
        assert (this.unitType != null) : "no unit type defined";
        assert (this.basicType != null) : "no basic type defined";
        assert (this.namespace != null) : "no namespace defined";
        assert (this.parents != null) : "no parents defined";
        assert (this.methods != null) : "no methods defined";
        assert (this.fields != null) : "no fields defined";
    }

    @Override
    public BasicType getBasicType() {
        return this.basicType;
    }

    @Override
    public String getBytecodeMethodName() {
        return this.bytecodeMethodName;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public UnitType getUnitType() {
        return this.unitType;
    }

    @Override
    public MethodTable methods() {
        return this.methods.get(this);
    }

    @Override
    public MethodTable virtualMethods() {
        return this.virtualMethods.get(this);
    }

    @Override
    public FieldTable fields() {
        return this.fields.get(this);
    }

    @Override
    public ParentTable parents() {
        return this.parents.get(this);
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.modifiers;
    }

    @Override
    public List<TypeInfo> getTypeArguments() {
        return ImmutableList.of();
    }

    @Override
    public TypeInfo getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public Equivalence.Wrapper<TypeInfo> getEquivalenceWrapper() {
        return this.typeComparator;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public CodeUnitDetails getCodeUnitDetails() {
        return this.codeUnit.get(this);
    }

    @Override
    public String getApexName() {
        return this.apexName;
    }

    public String toString() {
        return this.getApexName();
    }

    @Override
    public String getBytecodeName() {
        return this.bytecodeName;
    }

    @Override
    public String getTypeSignature() {
        return this.typeSignature;
    }

    public static abstract class Builder<B extends Builder, T extends AbstractTypeInfo>
    implements TypeNameProvider {
        private String apexName;
        private String bytecodeName;
        private String bytecodeMethodName;
        private BasicType basicType;
        private Initializer<FieldTable, TypeInfo> fields;
        private Initializer<MethodTable, TypeInfo> methods;
        private Initializer<MethodTable, TypeInfo> virtualMethods;
        private Initializer<ParentTable, TypeInfo> parents;
        private Initializer<CodeUnitDetails, TypeInfo> codeUnit;
        private Namespace namespace;
        private UnitType unitType;
        private ModifierGroup modifiers;
        private boolean resolved = true;
        private TypeInfo enclosingType;
        private String typeSignature;

        @SfdcCalled
        protected Builder() {
            this.setCodeUnitDetails(CodeUnitDetailsProvider.NONE);
        }

        public abstract T build();

        public T buildResolved() {
            this.setResolvedDefaults();
            return this.build();
        }

        public B setResolved(boolean resolved) {
            this.resolved = resolved;
            return (B)this;
        }

        public B setCodeUnitDetails(CodeUnitDetails codeUnit) {
            return this.setCodeUnitDetails(Initializers.ofInstance(codeUnit));
        }

        public B setCodeUnitDetails(Initializer<CodeUnitDetails, TypeInfo> codeUnit) {
            this.codeUnit = Initializers.memoize(codeUnit);
            return (B)this;
        }

        public B setViaSource(SourceFile source, CompilationUnit compilationUnit) {
            return this.setViaSource(source, null, compilationUnit);
        }

        public B setViaSource(SourceFile source, TypeInfo enclosingType, CompilationUnit compilationUnit) {
            FieldTable fields;
            switch (compilationUnit.match(UnitType.TO_UNIT_TYPE)) {
                case TRIGGER: {
                    fields = new StandardFieldTable();
                    break;
                }
                default: {
                    fields = new MultipleFieldTable();
                }
            }
            this.setUnitType(compilationUnit.match(UnitType.TO_UNIT_TYPE));
            this.setFields(fields);
            this.setMethods(new StandardMethodTable());
            this.setVirtualMethods(new StandardMethodTable());
            this.setParents(new StandardParentTable());
            this.setModifiers(compilationUnit.match(new ModifiersMatchBlock()));
            this.setNamespace(source.getNamespace());
            this.setEnclosingType(enclosingType);
            CodeUnitDetailsProvider.SourceCodeUnitDetails codeUnit = new CodeUnitDetailsProvider.SourceCodeUnitDetails(source, compilationUnit);
            this.setCodeUnitDetails(codeUnit);
            this.apexName = TypeNameFactory.createApexName(this.namespace, enclosingType, this.unitType, codeUnit.getName());
            this.bytecodeName = TypeNameFactory.createBytecodeName(this.namespace, enclosingType, this.unitType, codeUnit.getName());
            this.basicType = BasicType.APEX_OBJECT;
            return (B)this;
        }

        B setEnclosingType(TypeInfo enclosingType) {
            this.enclosingType = enclosingType;
            return (B)this;
        }

        @VisibleForTesting
        public B setEnclosingType(TypeInfo enclosingType, String name) {
            this.enclosingType = enclosingType;
            this.apexName = TypeNameFactory.createApexName(this.namespace, enclosingType, this.unitType, name);
            this.bytecodeName = TypeNameFactory.createBytecodeName(this.namespace, enclosingType, this.unitType, name);
            return (B)this;
        }

        public B setModifiers(ModifierGroup modifiers) {
            this.modifiers = modifiers;
            return (B)this;
        }

        B setNameViaClass(Class<?> clazz) {
            this.bytecodeName = TypeNameFactory.toBytecodeName(clazz);
            this.apexName = clazz.getSimpleName();
            return (B)this;
        }

        B setBytecodeMethodName(String bytecodeMethodName) {
            this.bytecodeMethodName = bytecodeMethodName;
            return (B)this;
        }

        public B setBasicType(BasicType basicType) {
            this.basicType = basicType;
            return (B)this;
        }

        public B setApexBytecodeName(String apexBytecodeName) {
            return ((Builder)this.setApexName(apexBytecodeName)).setBytecodeName(apexBytecodeName);
        }

        public B setParents(Initializer<ParentTable, TypeInfo> parents) {
            this.parents = Initializers.memoize(parents);
            return (B)this;
        }

        public B setParents(ParentTable parents) {
            return this.setParents(Initializers.ofInstance(parents));
        }

        public B setParents(TypeInfo superType) {
            return this.setParents(superType, ImmutableList.of());
        }

        public B setParents(TypeInfo superType, TypeInfo ... interfaces) {
            return this.setParents(superType, MoreLists.asImmutableList(interfaces));
        }

        public B setParents(TypeInfo superType, List<TypeInfo> interfaces) {
            return this.setParents(ParentTableFactory.create(superType, interfaces));
        }

        public B setFields(Initializer<FieldTable, TypeInfo> fields) {
            this.fields = Initializers.memoize(fields);
            return (B)this;
        }

        public B setFields(FieldTable fields) {
            return this.setFields(Initializers.ofInstance(fields));
        }

        public B setUnitType(UnitType unitType) {
            this.unitType = unitType;
            return (B)this;
        }

        Namespace getNamespace() {
            return this.namespace;
        }

        public B setNamespace(Namespace namespace) {
            this.namespace = namespace;
            return (B)this;
        }

        public B setMethods(MethodTable methods) {
            return this.setMethods(Initializers.ofInstance(methods));
        }

        public B setMethods(Initializer<MethodTable, TypeInfo> methods) {
            this.methods = Initializers.memoize(methods);
            return (B)this;
        }

        public B setVirtualMethods(MethodTable virtualMethods) {
            return this.setVirtualMethods(Initializers.ofInstance(virtualMethods));
        }

        public B setVirtualMethods(Initializer<MethodTable, TypeInfo> virtualMethods) {
            this.virtualMethods = Initializers.memoize(virtualMethods);
            return (B)this;
        }

        B setResolvedDefaults() {
            this.fields = MoreObjects.firstNonNull(this.fields, FieldTable.EMPTY);
            this.methods = MoreObjects.firstNonNull(this.methods, StandardMethodTable.EMPTY);
            this.parents = MoreObjects.firstNonNull(this.parents, StandardParentTable.EMPTY);
            this.unitType = MoreObjects.firstNonNull(this.unitType, UnitType.CLASS);
            this.namespace = MoreObjects.firstNonNull(this.namespace, Namespaces.EMPTY);
            this.modifiers = MoreObjects.firstNonNull(this.modifiers, ModifierGroups.GLOBAL_FINAL);
            this.basicType = MoreObjects.firstNonNull(this.basicType, BasicType.APEX_OBJECT);
            return (B)this;
        }

        @Override
        public String getApexName() {
            return this.apexName;
        }

        @Override
        public String getBytecodeName() {
            return this.bytecodeName;
        }

        @Override
        public String getTypeSignature() {
            return this.typeSignature == null ? (this.typeSignature = TypeNameUtil.createTypeSignature(this.getBytecodeName())) : this.typeSignature;
        }

        public B setApexName(String apexName) {
            this.apexName = apexName;
            return (B)this;
        }

        B setTypeSignature(String typeSignature) {
            this.typeSignature = typeSignature;
            return (B)this;
        }

        public B setBytecodeName(String bytecodeName) {
            this.bytecodeName = bytecodeName;
            return (B)this;
        }
    }
}

