/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.resolver.rules.ThreePartTypeNameResolveRule;
import apex.jorje.semantic.symbol.resolver.rules.TwoPartTypeNameResolveRules;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolutionOrderUtil;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolutionOrders;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveUtil;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.Version;
import java.util.Objects;

final class ThreePartTypeNameResolveRules {
    private ThreePartTypeNameResolveRules() {
    }

    static class GlobalModuleOuter
    implements ThreePartTypeNameResolveRule {
        static final ThreePartTypeNameResolveRule INSTANCE = new GlobalModuleOuter();

        private GlobalModuleOuter() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart, String thirdPart) {
            String candidateName = TypeNameResolveUtil.createTypeWithThreeParts(firstPart, secondPart, thirdPart);
            return symbols.find(referencingType, candidateName);
        }
    }

    static class NamespaceOuterInner
    implements ThreePartTypeNameResolveRule {
        static final ThreePartTypeNameResolveRule INSTANCE = new NamespaceOuterInner();

        private NamespaceOuterInner() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart, String thirdPart) {
            String candidateName = TypeNameResolveUtil.createInnerTypeWithNamespace(Namespaces.parse(firstPart), secondPart, thirdPart);
            return symbols.find(referencingType, candidateName);
        }
    }

    static class Pre150SystemSystemException
    implements ThreePartTypeNameResolveRule {
        static final ThreePartTypeNameResolveRule INSTANCE = new Pre150SystemSystemException();

        Pre150SystemSystemException() {
        }

        @Override
        public Version getMaxVersion() {
            return Version.V148;
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart, String thirdPart) {
            return TypeNameResolveUtil.SYSTEM.equals(firstPart) ? TwoPartTypeNameResolveRules.TwoPartSystemExceptions.INSTANCE.lookup(symbols, referencingType, secondPart, thirdPart) : null;
        }
    }

    static class ThreePartInnerTypeViaSubType
    implements ThreePartTypeNameResolveRule {
        static final ThreePartInnerTypeViaSubType INSTANCE = new ThreePartInnerTypeViaSubType();
        final TypeNameResolutionOrderUtil typeNameResolutionOrderUtil;

        private ThreePartInnerTypeViaSubType() {
            this(TypeNameResolutionOrderUtil.get());
        }

        ThreePartInnerTypeViaSubType(TypeNameResolutionOrderUtil typeNameResolutionOrderUtil) {
            this.typeNameResolutionOrderUtil = typeNameResolutionOrderUtil;
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart, String thirdPart) {
            if (!referencingType.parents().isResolved()) {
                return null;
            }
            TypeInfo subType = this.typeNameResolutionOrderUtil.getTypeFromTwoPartRules(symbols, referencingType, TypeNameResolutionOrders.DEFAULT, firstPart, secondPart);
            if (subType == null) {
                return null;
            }
            return TypeNameResolveUtil.InnerTypeViaSubTypeUtil.lookup(symbols, referencingType, subType, thirdPart);
        }
    }

    static class FlowInterviewTypeThree
    implements ThreePartTypeNameResolveRule {
        static final ThreePartTypeNameResolveRule INSTANCE = new FlowInterviewTypeThree();

        private FlowInterviewTypeThree() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart, String thirdPart) {
            Namespace namespace;
            Namespace outerNamespace = Namespaces.parse(firstPart);
            if (Namespaces.FLOW.equalsGlobal(outerNamespace) && "interview".equals(secondPart) && !(namespace = referencingType.getNamespace()).getGlobal().equalsIgnoreCase(thirdPart)) {
                return symbols.getSymbolProvider().getFlowInterviewType(symbols, referencingType, namespace, thirdPart);
            }
            return null;
        }
    }

    static class VfComponentTypeThree
    implements ThreePartTypeNameResolveRule {
        static final ThreePartTypeNameResolveRule INSTANCE = new VfComponentTypeThree();

        private VfComponentTypeThree() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart, String thirdPart) {
            Namespace outerNamespace = Namespaces.parse(firstPart);
            if (TypeNameResolveUtil.hasVfComponentTypes(symbols, referencingType) && Objects.equals(Namespaces.VF_COMPONENT, outerNamespace)) {
                Namespace myNamespace = Namespaces.parse(secondPart);
                Namespace innerNamespace = Objects.equals(Namespaces.VF, myNamespace) ? referencingType.getNamespace() : myNamespace;
                return symbols.getSymbolProvider().getVfComponentType(symbols, referencingType, innerNamespace, thirdPart);
            }
            return null;
        }
    }
}

