/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.common.iterable.SuperTypeIterable;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.resolver.rules.OnePartTypeNameResolveRule;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveUtil;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.Version;

final class OnePartTypeNameResolveRules {
    private OnePartTypeNameResolveRules() {
    }

    static class BuiltInMethodNamespace
    implements OnePartTypeNameResolveRule {
        static final OnePartTypeNameResolveRule INSTANCE = new BuiltInMethodNamespace();

        private BuiltInMethodNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart) {
            TypeInfo type = TypeNameResolveUtil.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.SYSTEM, firstPart);
            if (type != null) {
                return type;
            }
            type = TypeNameResolveUtil.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.SCHEMA, firstPart);
            if (type != null) {
                return type;
            }
            return TypeNameResolveUtil.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.EMPTY, firstPart);
        }
    }

    static class BuiltInSystemSchema
    implements OnePartTypeNameResolveRule {
        static final OnePartTypeNameResolveRule INSTANCE = new BuiltInSystemSchema();

        private BuiltInSystemSchema() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart) {
            TypeInfo type = TypeNameResolveUtil.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.SYSTEM, firstPart);
            if (type != null) {
                return type;
            }
            type = TypeNameResolveUtil.lookupInBuiltInException(symbols, referencingType, Namespaces.SYSTEM, firstPart);
            if (type != null) {
                return type;
            }
            type = TypeNameResolveUtil.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.SCHEMA, firstPart);
            if (type != null) {
                return type;
            }
            return null;
        }
    }

    static class FileBaseSystemNamespace
    implements OnePartTypeNameResolveRule {
        static final OnePartTypeNameResolveRule INSTANCE = new FileBaseSystemNamespace();

        private FileBaseSystemNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart) {
            return symbols.find(referencingType, TypeNameResolveUtil.createTypeWithNamespace(Namespaces.SYSTEM, firstPart));
        }
    }

    static class TopLevelTypeInSameNamespace
    implements OnePartTypeNameResolveRule {
        static final OnePartTypeNameResolveRule INSTANCE = new TopLevelTypeInSameNamespace();

        private TopLevelTypeInSameNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart) {
            String candidateName = TypeNameResolveUtil.createTypeWithNamespace(referencingType.getNamespace(), firstPart);
            return symbols.find(referencingType, candidateName);
        }
    }

    static class InnerTypeOfParentType
    implements OnePartTypeNameResolveRule {
        static final OnePartTypeNameResolveRule INSTANCE = new InnerTypeOfParentType(false);
        static final OnePartTypeNameResolveRule INSTANCE_CHECK_ENUMS = new InnerTypeOfParentType(true);
        private final boolean checkEnums;

        private InnerTypeOfParentType(boolean checkEnums) {
            this.checkEnums = checkEnums;
        }

        private TypeInfo lookupInnerType(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart) {
            if (!referencingType.parents().areSuperTypesResolved()) {
                return null;
            }
            for (TypeInfo currentType : new SuperTypeIterable(referencingType)) {
                TypeInfo candidateType = TypeNameResolveUtil.getInnerType(symbols, TypeInfoUtil.getTopLevel(currentType), referencingType, firstPart);
                if (candidateType == null) continue;
                return candidateType;
            }
            return null;
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart) {
            return TypeNameResolveUtil.filterToEnum(referencingType.getCodeUnitDetails().getVersion(), this.lookupInnerType(symbols, referencingType, firstPart), this.checkEnums);
        }
    }

    static class InnerTypeOfEnclosingType
    implements OnePartTypeNameResolveRule {
        static final OnePartTypeNameResolveRule INSTANCE = new InnerTypeOfEnclosingType(false);
        static final OnePartTypeNameResolveRule INSTANCE_CHECK_ENUMS = new InnerTypeOfEnclosingType(true);
        private final boolean checkEnums;

        private InnerTypeOfEnclosingType(boolean checkEnums) {
            this.checkEnums = checkEnums;
        }

        private TypeInfo lookupInnerType(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart) {
            if (TypeInfoUtil.isTopLevel(referencingType)) {
                return null;
            }
            TypeInfo enclosingType = TypeInfoUtil.getTopLevel(referencingType);
            if (!enclosingType.parents().areSuperTypesResolved()) {
                return TypeNameResolveUtil.getInnerType(symbols, enclosingType, referencingType, firstPart);
            }
            for (TypeInfo currentType : new SuperTypeIterable(enclosingType)) {
                TypeInfo candidateType = TypeNameResolveUtil.getInnerType(symbols, TypeInfoUtil.getTopLevel(currentType), referencingType, firstPart);
                if (candidateType == null) continue;
                return candidateType;
            }
            return null;
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart) {
            return TypeNameResolveUtil.filterToEnum(referencingType.getCodeUnitDetails().getVersion(), this.lookupInnerType(symbols, referencingType, firstPart), this.checkEnums);
        }
    }

    static class InnerTypeOfCurrentType
    implements OnePartTypeNameResolveRule {
        static final OnePartTypeNameResolveRule INSTANCE = new InnerTypeOfCurrentType(false);
        static final OnePartTypeNameResolveRule INSTANCE_CHECK_ENUMS = new InnerTypeOfCurrentType(true);
        private final boolean checkEnums;

        private InnerTypeOfCurrentType(boolean checkEnums) {
            this.checkEnums = checkEnums;
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart) {
            String innerTypeName = TypeNameResolveUtil.createInnerType(referencingType.getBytecodeName().toLowerCase(), firstPart);
            return TypeNameResolveUtil.filterToEnum(referencingType.getCodeUnitDetails().getVersion(), symbols.get(innerTypeName), this.checkEnums);
        }
    }

    static class ArgumentType
    implements OnePartTypeNameResolveRule {
        static final OnePartTypeNameResolveRule INSTANCE = new ArgumentType();

        private ArgumentType() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart) {
            if (symbols.staticContext().exists() && symbols.staticContext().get()) {
                return null;
            }
            if (GenericTypeInfoUtil.isGenericType(referencingType)) {
                for (TypeInfo typeArgument : referencingType.getTypeArguments()) {
                    if (!typeArgument.getApexName().equalsIgnoreCase(firstPart)) continue;
                    return typeArgument;
                }
            }
            return null;
        }
    }

    static class FileBaseSchemaNamespace
    implements OnePartTypeNameResolveRule {
        static final OnePartTypeNameResolveRule INSTANCE = new FileBaseSchemaNamespace();

        private FileBaseSchemaNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart) {
            return symbols.find(referencingType, TypeNameResolveUtil.createTypeWithNamespace(Namespaces.SCHEMA, firstPart));
        }
    }

    static class SObject
    implements OnePartTypeNameResolveRule {
        static final OnePartTypeNameResolveRule INSTANCE = new SObject();

        private SObject() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart) {
            return symbols.getSymbolProvider().getSObjectType(referencingType, firstPart);
        }
    }

    static class NamedScalarOrVoid
    implements OnePartTypeNameResolveRule {
        static final OnePartTypeNameResolveRule INSTANCE = new NamedScalarOrVoid();

        private NamedScalarOrVoid() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart) {
            TypeInfo type = TypeInfoTables.TYPES_BY_APEX_NAME.get(firstPart);
            if (type == null) {
                return null;
            }
            Version version = referencingType.getCodeUnitDetails().getVersion();
            return version.isGreaterThanOrEqual(type.getBasicType().getMinVersion()) ? type : null;
        }
    }
}

