/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.resolver.rules.FourPartTypeNameResolveRule;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolutionOrderUtil;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolutionOrders;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveUtil;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.Objects;

final class FourPartTypeNameResolveRules {
    private FourPartTypeNameResolveRules() {
    }

    static class GlobalModuleOuterInner
    implements FourPartTypeNameResolveRule {
        static final FourPartTypeNameResolveRule INSTANCE = new GlobalModuleOuterInner();

        private GlobalModuleOuterInner() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart, String thirdPart, String fourthPart) {
            String candidateName = TypeNameResolveUtil.createInnerTypeWithFourParts(firstPart, secondPart, thirdPart, fourthPart);
            return symbols.find(referencingType, candidateName);
        }
    }

    static class FourPartInnerTypeViaSubType
    implements FourPartTypeNameResolveRule {
        static final FourPartTypeNameResolveRule INSTANCE = new FourPartInnerTypeViaSubType();
        private final TypeNameResolutionOrderUtil typeNameResolutionOrderUtil;

        private FourPartInnerTypeViaSubType() {
            this(TypeNameResolutionOrderUtil.get());
        }

        FourPartInnerTypeViaSubType(TypeNameResolutionOrderUtil typeNameResolutionOrderUtil) {
            this.typeNameResolutionOrderUtil = typeNameResolutionOrderUtil;
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart, String thirdPart, String fourthPart) {
            if (!referencingType.parents().isResolved()) {
                return null;
            }
            TypeInfo subType = this.typeNameResolutionOrderUtil.getTypeFromThreePartRules(symbols, referencingType, TypeNameResolutionOrders.DEFAULT, firstPart, secondPart, thirdPart);
            if (subType == null) {
                return null;
            }
            return TypeNameResolveUtil.InnerTypeViaSubTypeUtil.lookup(symbols, referencingType, subType, fourthPart);
        }
    }

    static class FlowInterviewTypeFour
    implements FourPartTypeNameResolveRule {
        static final FourPartTypeNameResolveRule INSTANCE = new FlowInterviewTypeFour();

        private FlowInterviewTypeFour() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart, String thirdPart, String fourthPart) {
            Namespace outerNamespace = Namespaces.parse(firstPart);
            if (Namespaces.FLOW.equalsGlobal(outerNamespace) && Objects.equals("interview", secondPart)) {
                Namespace namespace = Namespaces.parse(thirdPart);
                return symbols.getSymbolProvider().getFlowInterviewType(symbols, referencingType, namespace, fourthPart);
            }
            return null;
        }
    }
}

