/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldInfo;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerFieldInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.VariableValidator;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.visibility.Visibility;

public class VariableValidateStoreVisitor
implements VariableVisitor<Boolean, VariableVisitor.Context> {
    private final VariableValidator validator;

    private VariableValidateStoreVisitor(VariableValidator validator) {
        this.validator = validator;
    }

    public static VariableValidateStoreVisitor create(SymbolResolver symbols, ValidationScope scope, AstNode node) {
        return new VariableValidateStoreVisitor(new VariableValidator(symbols, scope, node, Visibility.CheckType.CALLER_WRITE));
    }

    @Override
    public Boolean visit(LocalInfo info, VariableVisitor.Context context) {
        return this.validator.validateVisibility(info, context);
    }

    @Override
    public Boolean visit(StandardFieldInfo info, VariableVisitor.Context context) {
        return this.validator.validateFinalField(info, context) && this.validator.validateVisibility(info, context) && this.validator.validateForwardReference(info, context) && this.validator.validateContext(info, context) && this.validateEnumStore(info, context);
    }

    @Override
    public Boolean visit(StandardPropertyInfo info, VariableVisitor.Context context) {
        return this.validator.validateFinalProperty(info, context) && this.validator.validateVisibility(info, context) && this.validator.validateForwardReference(info, context) && this.validator.validateContext(info, context);
    }

    @Override
    public Boolean visit(TriggerFieldInfo info, VariableVisitor.Context context) {
        return this.validator.validateFinalField(info, context) && this.validator.validateVisibility(info, context) && this.validator.validateForwardReference(info, context);
    }

    @Override
    public Boolean visit(TriggerPropertyInfo info, VariableVisitor.Context context) {
        return this.validator.validateFinalProperty(info, context) && this.validator.validateVisibility(info, context) && this.validator.validateForwardReference(info, context);
    }

    @Override
    public Boolean visit(SObjectFieldInfo info, VariableVisitor.Context context) {
        if (context.shouldPeelSObject) {
            this.validator.illegalStore(info, context);
            return false;
        }
        if (!info.validateStore(this.validator, context)) {
            return false;
        }
        if (info.getModifiers().has(ModifierTypeInfos.STATIC)) {
            this.validator.illegalStore(info, context);
            return false;
        }
        return this.validator.validateNonFkReference(info, context) && this.validator.validateContext(info, context);
    }

    @Override
    public Boolean visit(DynamicFieldInfo info, VariableVisitor.Context context) {
        if (info.getStoreEmitter() == null || info.isAllowedOnlyInNewKeyValueObjectExpression()) {
            this.validator.illegalStore(info, context);
            return false;
        }
        return this.validator.validateVisibility(info, context) && this.validator.validateContext(info, context);
    }

    private boolean validateEnumStore(StandardFieldInfo info, VariableVisitor.Context context) {
        if (info.getDefiningType().getUnitType() == UnitType.ENUM) {
            this.validator.illegalStore(info, context);
            return false;
        }
        return true;
    }
}

