/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.common.base.WeakStringInterner;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.common.iterable.LinkedCaseInsensitiveMap;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;

public class LocalVariableScope {
    @VisibleForTesting
    static final Map<String, LocalInfo> EMPTY_MAP = ImmutableMap.of();
    private Map<String, LocalInfo> locals = EMPTY_MAP;
    private LocalInfo declaration = null;

    public Collection<LocalInfo> all() {
        return this.locals.values();
    }

    void add(LocalInfo local) {
        this.createLocalsMap();
        if (local.getName() == null) {
            this.locals.put(WeakStringInterner.get().intern("++null++" + this.locals.size()), local);
            return;
        }
        this.locals.put(local.getName(), local);
    }

    private void createLocalsMap() {
        if (this.locals == EMPTY_MAP) {
            this.locals = new LinkedCaseInsensitiveMap<LocalInfo>();
        }
    }

    LocalInfo get(String name) {
        return name == null ? null : this.locals.get(name);
    }

    LocalInfo lookup(String name, Location loc, boolean allowLazyDeclaration) {
        LocalInfo local = this.locals.get(name);
        if (local == null) {
            return null;
        }
        if (this.isCalledBeforeDeclared(local, loc)) {
            if (allowLazyDeclaration) {
                local.setUsedBeforeDefined();
                return local;
            }
            return null;
        }
        return local;
    }

    private boolean isCalledBeforeDeclared(LocalInfo local, Location loc) {
        return !Locations.lessThanOrEqual(local.getLoc(), loc) || this.isDeclaration(local);
    }

    private boolean isDeclaration(LocalInfo local) {
        return this.declaration != null && this.declaration.getName().equalsIgnoreCase(local.getName());
    }

    int size() {
        return this.locals.size();
    }

    public void setDeclaration(LocalInfo declaration) {
        this.declaration = declaration;
    }

    public void clearDeclaration() {
        this.declaration = null;
    }

    @VisibleForTesting
    Map<String, LocalInfo> getLocals() {
        return this.locals;
    }
}

