/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method.signature;

import apex.common.base.Initializer;
import apex.common.base.Initializers;
import apex.common.base.MoreStrings;
import apex.common.base.ObjectHash;
import apex.common.base.WeakStringInterner;
import apex.jorje.semantic.common.Constants;
import apex.jorje.semantic.symbol.member.method.signature.SignatureUtil;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import com.google.common.collect.MoreLists;
import java.util.List;
import java.util.Objects;

public class Signature {
    private static final Initializer<String, Signature> CREATE_APEX_NAME = signature -> SignatureUtil.createStringRepresentation(signature.definingType, signature.name, signature.returnType, signature.parameterTypes);
    private static final Initializer<String, Signature> CREATE_TYPE_DESCRIPTOR = TypeEraser::eraseSignature;
    private final String name;
    private final TypeInfo definingType;
    private final TypeInfo returnType;
    private final List<TypeInfo> parameterTypes;
    private final Initializer<String, Signature> typeDescriptor;
    private final Initializer<String, Signature> apexSignature;

    Signature(String name, TypeInfo definingType, TypeInfo returnType, List<TypeInfo> parameterTypes) {
        assert (!Constants.isSuper(name) && !Constants.isThis(name));
        this.name = WeakStringInterner.get().intern(name);
        this.definingType = definingType;
        this.returnType = returnType;
        this.parameterTypes = MoreLists.toImmutableList(parameterTypes);
        this.typeDescriptor = Initializers.memoize(CREATE_TYPE_DESCRIPTOR);
        this.apexSignature = Initializers.memoize(CREATE_APEX_NAME);
    }

    public String getName() {
        return this.name;
    }

    public boolean isConstructor() {
        return SignatureUtil.isConstructor(this.name);
    }

    public TypeInfo getReturnType() {
        return this.returnType;
    }

    public List<TypeInfo> getParameterTypes() {
        return this.parameterTypes;
    }

    public String getValue() {
        return this.typeDescriptor.get(this);
    }

    public int hashCode() {
        return ObjectHash.hash(this.name, this.returnType, (Object)TypeInfoEquivalence.doHash(this.parameterTypes));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)o;
        return Objects.equals(this.name, signature.name) && TypeInfoEquivalence.isEquivalent(this.returnType, signature.returnType) && TypeInfoEquivalence.isEquivalent(this.parameterTypes, signature.parameterTypes);
    }

    public String toString() {
        return this.apexSignature.get(this);
    }

    public boolean equalsSignature(Signature that) {
        return SignatureUtil.equalsSignature(this.name, that.name, this.getParameterTypes(), that.getParameterTypes());
    }

    public int hashCodeSignature() {
        return MoreStrings.lowerCaseHashCode(this.name);
    }
}

