/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.common.base.Initializer;
import apex.common.base.Initializers;
import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.bcl.validators.JavaSfdcOnlyAnnotation;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodNameMangler;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfoBuilder;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class StandardMethodInfo
implements MethodInfo {
    private final TypeInfo definingType;
    private final Identifier name;
    private final List<Parameter> parameters;
    private final InvocationType invocationType;
    private final TypeInfo returnType;
    private final Signature signature;
    private final Signature emitSignature;
    private final boolean isConstructor;
    private final ModifierGroup modifiers;
    private final JavaSfdcOnlyAnnotation javaSfdcOnlyAnnotation;
    private final Generated generated;
    private final boolean isStaticInitialization;
    private final Initializer<String, MethodInfo> mangledName;
    private final ProfilingType profilingType;
    private final boolean isDuckTyped;
    private final List<BuiltInMethodValidator> validators;
    private final boolean isPropertyAccessor;
    private final DmlOperation dmlOperation;
    private String canonicalName;
    private Initializer<String, MethodInfo> mangledCanonicalName;
    private Set<MethodInfo> methodInterfaces;

    StandardMethodInfo(StandardMethodInfoBuilder builder) {
        this.definingType = builder.getDefiningType();
        this.name = builder.getName();
        this.modifiers = builder.getModifiers();
        this.javaSfdcOnlyAnnotation = builder.getJavaSfdcOnlyAnnotation();
        this.parameters = builder.getParameters();
        this.returnType = builder.getReturnType().get();
        this.invocationType = builder.getInvocationType();
        this.isConstructor = builder.isConstructor();
        String signatureName = this.isConstructor ? "<init>" : this.name.getValue();
        this.signature = SignatureFactory.create(signatureName, this.definingType, this.returnType, Parameter.toType(this.parameters));
        this.emitSignature = MoreObjects.firstNonNull(builder.getEmitSignature(), this.signature);
        this.isStaticInitialization = Objects.equals(this.name.getValue(), "<clinit>");
        this.canonicalName = this.name.getValue();
        this.generated = builder.getGenerated();
        this.mangledName = Initializers.memoize(method -> MethodNameMangler.getMangledName(method, method.getSignature().getName()));
        this.mangledCanonicalName = this.mangledName;
        this.profilingType = builder.getProfilingType();
        this.isDuckTyped = builder.isDuckTyped();
        this.validators = builder.getValidators();
        this.isPropertyAccessor = builder.isPropertyAccessor();
        this.methodInterfaces = ImmutableSet.of();
        this.dmlOperation = builder.getDmlOperation();
    }

    public static StandardMethodInfoBuilder builder() {
        return new StandardMethodInfoBuilder();
    }

    @Override
    public List<TypeInfo> getParameterTypes() {
        return this.signature.getParameterTypes();
    }

    @Override
    public TypeInfo getReturnType() {
        return this.returnType;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public Signature getEmitSignature() {
        return this.emitSignature;
    }

    @Override
    public InvocationType getInvocationType() {
        return this.invocationType;
    }

    @Override
    public JavaSfdcOnlyAnnotation getJavaSfdcOnlyAnnotation() {
        return this.javaSfdcOnlyAnnotation;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isConstructor() {
        return this.isConstructor;
    }

    @Override
    public boolean isPropertyAccessor() {
        return this.isPropertyAccessor;
    }

    @Override
    public boolean isStaticInitialization() {
        return this.isStaticInitialization;
    }

    @Override
    public String getCanonicalName() {
        return this.canonicalName;
    }

    @Override
    public void setCanonicalName(String canonicalName) {
        assert (canonicalName.equalsIgnoreCase(this.signature.getName()));
        this.canonicalName = canonicalName;
        this.mangledCanonicalName = Initializers.memoize(method -> MethodNameMangler.getMangledName(method, method.getCanonicalName()));
    }

    @Override
    public Set<MethodInfo> getMethodInterfaces() {
        return this.methodInterfaces;
    }

    @Override
    public void setMethodInterfaces(Set<MethodInfo> methodInterfaces) {
        this.methodInterfaces = methodInterfaces;
    }

    @Override
    public Generated getGenerated() {
        return this.generated;
    }

    @Override
    public boolean hasReturnValue() {
        return !TypeInfoEquivalence.isEquivalent(this.returnType, TypeInfos.VOID);
    }

    @Override
    public AsmMethod.Builder getAsmMethodBuilder() {
        return AsmMethod.builder().invoke(this.invocationType).setDefiningTypeAsBytecodeMethodName(this.getDefiningType()).setFunction(this.getMangledCanonicalName()).setSignature(this.emitSignature);
    }

    @Override
    public AsmMethod getAsmMethod() {
        return this.getAsmMethodBuilder().build();
    }

    @Override
    public String getMangledName() {
        return this.mangledName.get(this);
    }

    @Override
    public String getMangledCanonicalName() {
        return this.mangledCanonicalName.get(this);
    }

    @Override
    public ProfilingType getProfilingType() {
        return this.profilingType;
    }

    @Override
    public boolean isDuckTyped() {
        return this.isDuckTyped;
    }

    @Override
    public List<BuiltInMethodValidator> getValidators() {
        return this.validators;
    }

    @Override
    public boolean needsReturnTypeConversion() {
        return false;
    }

    @Override
    public DmlOperation getDmlOperation() {
        return this.dmlOperation;
    }

    @Override
    public String getName() {
        return this.name.getValue();
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Member.Type getMemberType() {
        return Member.Type.METHOD;
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.modifiers;
    }

    @Override
    public Location getLoc() {
        return this.name.getLoc();
    }

    public String toString() {
        return this.getSignature().toString();
    }
}

