/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.data.Location;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.bcl.validators.JavaSfdcOnlyAnnotation;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import java.util.List;
import java.util.Set;

public class ReifiedMethodInfo
implements MethodInfo {
    private final MethodInfo unreifiedMethod;
    private final TypeInfo definingType;
    private final TypeInfo returnType;
    private final List<Parameter> parameters;
    private final Signature signature;
    private final boolean needsReturnTypeConversion;
    private final Signature emitSignature;

    public ReifiedMethodInfo(MethodInfo unreifiedMethod, TypeInfo returnType, List<Parameter> parameters, TypeInfo definingType) {
        this.unreifiedMethod = unreifiedMethod;
        this.returnType = returnType;
        this.parameters = parameters;
        this.definingType = definingType;
        this.signature = SignatureFactory.create(unreifiedMethod.getName(), definingType, returnType, Parameter.toType(parameters));
        this.needsReturnTypeConversion = !TypeInfoEquivalence.isEquivalent(returnType, unreifiedMethod.getReturnType());
        Signature unreifiedSignature = unreifiedMethod.getEmitSignature();
        this.emitSignature = this.needsReturnTypeConversion && !TypeInfoUtil.isFastCallType(unreifiedMethod.getDefiningType()) ? SignatureFactory.create(unreifiedSignature.getName(), (TypeInfo)TypeInfos.OBJECT, unreifiedSignature.getParameterTypes()) : unreifiedSignature;
    }

    @Override
    public List<TypeInfo> getParameterTypes() {
        return this.signature.getParameterTypes();
    }

    @Override
    public TypeInfo getReturnType() {
        return this.returnType;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public Signature getEmitSignature() {
        return this.emitSignature;
    }

    @Override
    public InvocationType getInvocationType() {
        return this.unreifiedMethod.getInvocationType();
    }

    @Override
    public JavaSfdcOnlyAnnotation getJavaSfdcOnlyAnnotation() {
        return this.unreifiedMethod.getJavaSfdcOnlyAnnotation();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isConstructor() {
        return this.unreifiedMethod.isConstructor();
    }

    @Override
    public boolean isPropertyAccessor() {
        return this.unreifiedMethod.isPropertyAccessor();
    }

    @Override
    public boolean isStaticInitialization() {
        return this.unreifiedMethod.isStaticInitialization();
    }

    @Override
    public String getCanonicalName() {
        return this.unreifiedMethod.getCanonicalName();
    }

    @Override
    public void setCanonicalName(String canonicalName) {
        this.unreifiedMethod.setCanonicalName(canonicalName);
    }

    @Override
    public Set<MethodInfo> getMethodInterfaces() {
        return this.unreifiedMethod.getMethodInterfaces();
    }

    @Override
    public void setMethodInterfaces(Set<MethodInfo> methodInterfaces) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generated getGenerated() {
        return this.unreifiedMethod.getGenerated();
    }

    @Override
    public boolean hasReturnValue() {
        return this.unreifiedMethod.hasReturnValue();
    }

    @Override
    public AsmMethod.Builder getAsmMethodBuilder() {
        return this.unreifiedMethod.getAsmMethodBuilder().setSignature(this.emitSignature);
    }

    @Override
    public AsmMethod getAsmMethod() {
        return this.getAsmMethodBuilder().build();
    }

    @Override
    public String getMangledName() {
        return this.unreifiedMethod.getMangledName();
    }

    @Override
    public String getMangledCanonicalName() {
        return this.unreifiedMethod.getMangledCanonicalName();
    }

    @Override
    public ProfilingType getProfilingType() {
        return this.unreifiedMethod.getProfilingType();
    }

    @Override
    public boolean isDuckTyped() {
        return this.unreifiedMethod.isDuckTyped();
    }

    @Override
    public List<BuiltInMethodValidator> getValidators() {
        return this.unreifiedMethod.getValidators();
    }

    @Override
    public boolean needsReturnTypeConversion() {
        return this.needsReturnTypeConversion;
    }

    @Override
    public DmlOperation getDmlOperation() {
        return this.unreifiedMethod.getDmlOperation();
    }

    @Override
    public String getName() {
        return this.unreifiedMethod.getName();
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Member.Type getMemberType() {
        return this.unreifiedMethod.getMemberType();
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.unreifiedMethod.getModifiers();
    }

    @Override
    public Location getLoc() {
        return this.unreifiedMethod.getLoc();
    }

    public String toString() {
        return this.getSignature().toString();
    }

    MethodInfo getUnreifiedMethod() {
        return this.unreifiedMethod;
    }
}

