/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.data.Location;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.bcl.validators.JavaSfdcOnlyAnnotation;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Set;

public class ProxyMethodInfo
implements MethodInfo {
    private final MethodInfo methodInfo;
    private final TypeInfo callerType;
    private final Signature signature;
    private final Signature emitSignature;

    public ProxyMethodInfo(TypeInfo callerType, MethodInfo methodInfo) {
        this.callerType = callerType;
        this.methodInfo = methodInfo;
        this.signature = SignatureFactory.create(methodInfo.getName(), callerType, methodInfo.getReturnType(), methodInfo.getParameterTypes());
        this.emitSignature = MoreObjects.firstNonNull(methodInfo.getEmitSignature(), this.signature);
    }

    @Override
    public List<TypeInfo> getParameterTypes() {
        return this.signature.getParameterTypes();
    }

    @Override
    public TypeInfo getReturnType() {
        return this.methodInfo.getReturnType();
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public Signature getEmitSignature() {
        return this.emitSignature;
    }

    @Override
    public InvocationType getInvocationType() {
        return this.methodInfo.getInvocationType();
    }

    @Override
    public JavaSfdcOnlyAnnotation getJavaSfdcOnlyAnnotation() {
        return this.methodInfo.getJavaSfdcOnlyAnnotation();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.methodInfo.getParameters();
    }

    @Override
    public boolean isConstructor() {
        return this.methodInfo.isConstructor();
    }

    @Override
    public boolean isPropertyAccessor() {
        return this.methodInfo.isPropertyAccessor();
    }

    @Override
    public boolean isStaticInitialization() {
        return this.methodInfo.isStaticInitialization();
    }

    @Override
    public String getCanonicalName() {
        return this.methodInfo.getCanonicalName();
    }

    @Override
    public void setCanonicalName(String canonicalName) {
        this.methodInfo.setCanonicalName(canonicalName);
    }

    @Override
    public Set<MethodInfo> getMethodInterfaces() {
        return this.methodInfo.getMethodInterfaces();
    }

    @Override
    public void setMethodInterfaces(Set<MethodInfo> methodInterfaces) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generated getGenerated() {
        return this.methodInfo.getGenerated();
    }

    @Override
    public boolean hasReturnValue() {
        return this.methodInfo.hasReturnValue();
    }

    @Override
    public AsmMethod.Builder getAsmMethodBuilder() {
        return AsmMethod.builder().invoke(this.getInvocationType()).setDefiningTypeAsBytecodeMethodName(this.getDefiningType()).setFunction(this.getMangledCanonicalName()).setSignature(this.emitSignature);
    }

    @Override
    public AsmMethod getAsmMethod() {
        return this.getAsmMethodBuilder().build();
    }

    @Override
    public String getMangledName() {
        return this.methodInfo.getMangledName();
    }

    @Override
    public String getMangledCanonicalName() {
        return this.methodInfo.getMangledCanonicalName();
    }

    @Override
    public ProfilingType getProfilingType() {
        return this.methodInfo.getProfilingType();
    }

    @Override
    public boolean isDuckTyped() {
        return this.methodInfo.isDuckTyped();
    }

    @Override
    public List<BuiltInMethodValidator> getValidators() {
        return this.methodInfo.getValidators();
    }

    @Override
    public boolean needsReturnTypeConversion() {
        return this.methodInfo.needsReturnTypeConversion();
    }

    @Override
    public DmlOperation getDmlOperation() {
        return this.methodInfo.getDmlOperation();
    }

    @Override
    public String getName() {
        return this.methodInfo.getName();
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.callerType;
    }

    @Override
    public Member.Type getMemberType() {
        return this.methodInfo.getMemberType();
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.methodInfo.getModifiers();
    }

    @Override
    public Location getLoc() {
        return this.methodInfo.getLoc();
    }

    public String toString() {
        return this.getSignature().toString();
    }
}

