/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler.parser;

import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.parser.impl.ApexLexer;
import apex.jorje.parser.impl.ApexParser;
import apex.jorje.services.exception.InternalException;
import apex.jorje.services.exception.ParseException;
import com.google.common.collect.MoreLists;
import java.util.List;

public class ParserOutput {
    private final List<InternalException> internalErrors;
    private final List<ParseException> parseErrors;
    private final CompilationUnit unit;

    private ParserOutput(List<InternalException> internalErrors, List<ParseException> parseErrors, CompilationUnit unit) {
        this.internalErrors = internalErrors;
        this.parseErrors = parseErrors;
        this.unit = unit;
    }

    static ParserOutput createFromAntlr(ApexParser parser, ApexLexer lexer, CompilationUnit unit) {
        return new ParserOutput(MoreLists.concatLists(lexer.getInternalErrors(), parser.getInternalErrors()), MoreLists.concatLists(lexer.getParseErrors(), parser.getParseErrors()), unit);
    }

    public List<InternalException> getInternalErrors() {
        return this.internalErrors;
    }

    public List<ParseException> getParseErrors() {
        return this.parseErrors;
    }

    public CompilationUnit getUnit() {
        return this.unit;
    }
}

