/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.common.base.WeakStringInterner;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Objects;

public class Namespace
implements Serializable {
    private static final long serialVersionUID = 3310669935514492904L;
    private final String global;
    private final String module;
    private final String name;
    private volatile transient String nameLowerCase;
    private volatile transient String bytecodeNameLower;

    Namespace(String global, String module) {
        this.global = WeakStringInterner.get().intern(MoreObjects.firstNonNull(global, ""));
        this.module = WeakStringInterner.get().intern(MoreObjects.firstNonNull(module, ""));
        String s = Strings.isNullOrEmpty(module) ? this.global : this.global + "__" + this.module;
        this.name = WeakStringInterner.get().intern(s);
    }

    public static boolean isEmptyOrNull(Namespace namespace) {
        return namespace == null || namespace.equals(Namespaces.EMPTY);
    }

    public static boolean equals(TypeInfo left, TypeInfo right) {
        assert (left != null && right != null && left.getNamespace() != null && right.getNamespace() != null);
        return Objects.equals(left.getNamespace(), right.getNamespace());
    }

    public static boolean equals(Namespace left, Namespace right) {
        return Objects.equals(MoreObjects.firstNonNull(left, Namespaces.EMPTY), MoreObjects.firstNonNull(right, Namespaces.EMPTY));
    }

    public String getGlobal() {
        return this.global;
    }

    public boolean hasModule() {
        return !Strings.isNullOrEmpty(this.module);
    }

    public String getModule() {
        return this.module;
    }

    public String getNameLower() {
        if (this.nameLowerCase == null) {
            this.nameLowerCase = this.name.toLowerCase();
        }
        return this.nameLowerCase;
    }

    public String getBytecodeNameLower() {
        if (this.bytecodeNameLower == null) {
            this.bytecodeNameLower = Strings.isNullOrEmpty(this.module) ? this.global.toLowerCase() : (this.global + "/" + this.module).toLowerCase();
        }
        return this.bytecodeNameLower;
    }

    public int hashCode() {
        return Objects.hashCode(this.getNameLower());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Namespace namespace = (Namespace)o;
        return Objects.equals(this.getNameLower(), namespace.getNameLower());
    }

    public final String toString() {
        return this.name;
    }

    public boolean equalsGlobal(Namespace other) {
        return !(this.global != null && other.global != null ? !this.global.equalsIgnoreCase(other.global) : this.global != null || other.global != null);
    }
}

