/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.common.base.MoreStrings;
import apex.common.base.WeakStringInterner;
import com.google.common.collect.MoreMaps;
import java.util.HashMap;
import java.util.Map;

public class CaseInsensitiveMap<V>
extends HashMap<String, V> {
    private static final long serialVersionUID = 1735666087652457788L;

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    @Override
    public V get(Object key) {
        return key instanceof String ? (V)super.get(MoreStrings.toLowerCase((String)key)) : null;
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && super.containsKey(MoreStrings.toLowerCase((String)key));
    }

    @Override
    public V put(String key, V value) {
        return super.put(WeakStringInterner.get().intern(MoreStrings.toLowerCase(key)), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return key instanceof String ? (V)super.remove(WeakStringInterner.get().intern(MoreStrings.toLowerCase((String)key))) : null;
    }

    public static class Builder<V> {
        private final CaseInsensitiveMap<V> map = new CaseInsensitiveMap();

        private Builder() {
        }

        public Builder<V> put(String key, V value) {
            this.map.put(key, value);
            return this;
        }

        public Map<String, V> build() {
            return MoreMaps.toImmutableMap(this.map);
        }
    }
}

