/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common;

import apex.common.base.MoreStrings;
import apex.jorje.data.Identifier;
import apex.jorje.data.ast.LiteralType;
import apex.jorje.semantic.ast.expression.ArrayLoadExpression;
import apex.jorje.semantic.ast.expression.ArrayStoreExpression;
import apex.jorje.semantic.ast.expression.AssignmentExpression;
import apex.jorje.semantic.ast.expression.BooleanExpression;
import apex.jorje.semantic.ast.expression.CastExpression;
import apex.jorje.semantic.ast.expression.EmptyReferenceExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.PostfixExpression;
import apex.jorje.semantic.ast.expression.PrefixExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.expression.SoslExpression;
import apex.jorje.semantic.ast.expression.SuperMethodCallExpression;
import apex.jorje.semantic.ast.expression.SuperVariableExpression;
import apex.jorje.semantic.ast.expression.ThisMethodCallExpression;
import apex.jorje.semantic.ast.expression.ThisVariableExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.BreakStatement;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.ContinueStatement;
import apex.jorje.semantic.ast.statement.ExpressionStatement;
import apex.jorje.semantic.ast.statement.FieldDeclaration;
import apex.jorje.semantic.ast.statement.FieldDeclarationStatements;
import apex.jorje.semantic.ast.statement.ReturnStatement;
import apex.jorje.semantic.ast.statement.TryCatchFinallyBlockStatement;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.statement.VariableDeclarationStatements;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.StackScope;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.stream.Collectors;

public class PrintVisitor
extends AstVisitor<StackScope<String>> {
    private static final PrintVisitor INSTANCE = new PrintVisitor();

    private PrintVisitor() {
    }

    public static PrintVisitor get() {
        return INSTANCE;
    }

    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public void visitEnd(ArrayLoadExpression node, StackScope<String> scope) {
        String index = scope.pop();
        String expression = scope.pop();
        scope.push(expression + "[" + index + "]");
    }

    @Override
    public void visitEnd(ArrayStoreExpression node, StackScope<String> scope) {
        String index = scope.pop();
        String expression = scope.pop();
        scope.push(expression + "[" + index + "]");
    }

    @Override
    public void visitEnd(AssignmentExpression node, StackScope<String> scope) {
        String rhs = scope.pop();
        String lhs = scope.pop();
        scope.push(lhs + " " + (Object)((Object)node.getOp()) + " " + rhs);
    }

    @Override
    public void visitEnd(BooleanExpression node, StackScope<String> scope) {
        String rhs = scope.pop();
        String lhs = scope.pop();
        scope.push(lhs + " " + (Object)((Object)node.getOp()) + " " + rhs);
    }

    @Override
    public void visitEnd(CastExpression node, StackScope<String> scope) {
        scope.push("(" + node.getType() + ")" + scope.pop());
    }

    @Override
    public boolean visit(LiteralExpression node, StackScope<String> scope) {
        return false;
    }

    @Override
    public void visitEnd(LiteralExpression node, StackScope<String> scope) {
        String value = Objects.toString(node.getLiteral());
        if (node.getLiteralType() == LiteralType.STRING) {
            scope.push("'" + value + "'");
        } else if (node.getLiteralType() == LiteralType.DOUBLE) {
            scope.push(value + "D");
        } else if (node.getLiteralType() == LiteralType.LONG) {
            scope.push(value + "L");
        } else {
            scope.push(value);
        }
    }

    @Override
    public void visitEnd(ReferenceExpression node, StackScope<String> scope) {
        String dottedExpr = node.isNoopDottedExpression() ? "" : scope.pop() + ".";
        String identifiers = node.getNames().isEmpty() ? "" : node.getNames().stream().map(Identifier::getValue).collect(Collectors.joining(".", "", "."));
        scope.push(dottedExpr + identifiers);
    }

    @Override
    public void visitEnd(EmptyReferenceExpression node, StackScope<String> scope) {
        scope.push("");
    }

    @Override
    public void visitEnd(MethodCallExpression node, StackScope<String> scope) {
        String methodCallTail = this.getMethodCallTail(scope, node.getInputParameters().size());
        scope.push(scope.pop() + node.getMethodName() + methodCallTail);
    }

    @Override
    public void visitEnd(NewObjectExpression node, StackScope<String> scope) {
        scope.push("new " + node.getMethodName() + this.getMethodCallTail(scope, node.getParameters().size()));
    }

    @Override
    public void visitEnd(PostfixExpression node, StackScope<String> scope) {
        scope.push(scope.pop() + (Object)((Object)node.getOp()));
    }

    @Override
    public void visitEnd(PrefixExpression node, StackScope<String> scope) {
        scope.push((Object)((Object)node.getOp()) + scope.pop());
    }

    @Override
    public void visitEnd(VariableExpression node, StackScope<String> scope) {
        scope.push(scope.pop() + node.getIdentifier().getValue());
    }

    @Override
    public void visitEnd(BlockStatement node, StackScope<String> scope) {
        int numStatements = node.getStatements().size();
        ArrayDeque<String> statements = new ArrayDeque<String>();
        for (int i = 0; i < numStatements; ++i) {
            statements.push(scope.pop());
        }
        String block = statements.stream().collect(Collectors.joining("", "{\n", "}"));
        scope.push(block);
    }

    @Override
    public void visitEnd(BreakStatement node, StackScope<String> scope) {
        scope.push("break;\n");
    }

    @Override
    public void visitEnd(ContinueStatement node, StackScope<String> scope) {
        scope.push("continue;\n");
    }

    @Override
    public void visitEnd(ExpressionStatement node, StackScope<String> scope) {
        scope.push(scope.pop() + ";\n");
    }

    @Override
    public void visitEnd(FieldDeclaration node, StackScope<String> scope) {
        this.pushDeclaration(scope, node.getFieldInfo(), node.getAssignment());
    }

    @Override
    public void visitEnd(FieldDeclarationStatements node, StackScope<String> scope) {
        this.pushDeclarations(scope, node.getType(), node.getDeclarations().size());
    }

    @Override
    public boolean visit(ReturnStatement node, StackScope<String> scope) {
        return true;
    }

    @Override
    public void visitEnd(ReturnStatement node, StackScope<String> scope) {
        scope.push(scope.isEmpty() ? "return;\n" : "return " + scope.pop() + ";\n");
    }

    @Override
    public void visitEnd(VariableDeclaration node, StackScope<String> scope) {
        this.pushDeclaration(scope, node.getLocalInfo(), node.getAssignment());
    }

    @Override
    public void visitEnd(VariableDeclarationStatements node, StackScope<String> scope) {
        this.pushDeclarations(scope, node.getType(), node.getDeclarations().size());
    }

    @Override
    public void visitEnd(SoqlExpression node, StackScope<String> scope) {
        scope.push("[" + node.getCanonicalQuery() + "]");
    }

    @Override
    public void visitEnd(SoslExpression node, StackScope<String> scope) {
        scope.push("[" + node.getCanonicalQuery() + "]");
    }

    @Override
    public void visitEnd(CatchBlockStatement node, StackScope<String> scope) {
        scope.push(" catch (" + node.getVariable().getType() + " " + node.getVariable().getName() + ") " + scope.pop());
    }

    @Override
    public boolean visit(TryCatchFinallyBlockStatement node, StackScope<String> scope) {
        node.getTryBlock().traverse(this, scope);
        StringBuilder builder = new StringBuilder().append("try ").append(scope.pop());
        for (CatchBlockStatement catchBlock : node.getCatchBlocks()) {
            catchBlock.traverse(this, scope);
            builder.append(scope.pop());
        }
        builder.append(" finally ");
        node.getFinallyBlock().traverse(this, scope);
        builder.append(scope.pop());
        builder.append("\n");
        scope.push(builder.toString());
        return false;
    }

    @Override
    public void visitEnd(SuperMethodCallExpression node, StackScope<String> scope) {
        scope.push("super" + this.getMethodCallTail(scope, node.getNumParameters()));
    }

    @Override
    public void visitEnd(ThisMethodCallExpression node, StackScope<String> scope) {
        scope.push("this" + this.getMethodCallTail(scope, node.getNumParameters()));
    }

    @Override
    public void visitEnd(SuperVariableExpression node, StackScope<String> scope) {
        scope.push("super");
    }

    @Override
    public void visitEnd(ThisVariableExpression node, StackScope<String> scope) {
        scope.push("this");
    }

    private void pushDeclaration(StackScope<String> scope, Variable variable, Expression assignment) {
        String name;
        if (assignment != Expression.NOOP) {
            scope.pop();
            name = variable.getName() + " = " + scope.pop();
        } else {
            scope.pop();
            name = variable.getName();
        }
        scope.push(name);
    }

    private void pushDeclarations(StackScope<String> scope, TypeInfo type, int declarationSize) {
        ArrayDeque<String> declarations = new ArrayDeque<String>();
        for (int i = 0; i < declarationSize; ++i) {
            declarations.push(scope.pop());
        }
        String declaration = declarations.stream().collect(Collectors.joining(", ", type + " ", ";\n"));
        scope.push(declaration);
    }

    private String getMethodCallTail(StackScope<String> scope, int parameterSize) {
        ArrayDeque<String> params = new ArrayDeque<String>();
        for (int i = 0; i < parameterSize; ++i) {
            params.push(scope.pop());
        }
        return params.stream().collect(MoreStrings.ON_COMMA_ENCLOSING_PARENTHESISES);
    }
}

