/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.AnonymousClass;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.I18nSupport;

public class SymbolVisitor
extends AstVisitor<SymbolScope> {
    @Override
    public boolean visit(AnonymousClass node, SymbolScope scope) {
        this.visitCompilation(node, scope);
        return true;
    }

    @Override
    public boolean visit(UserClass node, SymbolScope scope) {
        this.visitCompilation(node, scope);
        return true;
    }

    @Override
    public boolean visit(UserEnum node, SymbolScope scope) {
        this.visitCompilation(node, scope);
        return false;
    }

    @Override
    public boolean visit(UserInterface node, SymbolScope scope) {
        this.visitCompilation(node, scope);
        return false;
    }

    @Override
    public boolean visit(UserTrigger node, SymbolScope scope) {
        this.visitCompilation(node, scope);
        return true;
    }

    private void visitCompilation(Compilation node, SymbolScope scope) {
        if (scope.getSymbols().add(node.getDefiningType()) || this.isInnerTypeSameNameAsEnclosingType(node.getDefiningType())) {
            scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("duplicate.type.name", node.getDefiningType()));
        }
    }

    private boolean isInnerTypeSameNameAsEnclosingType(TypeInfo type) {
        return TypeInfoUtil.isInnerType(type) && TypeInfoUtil.getTopLevel(type).getCodeUnitDetails().getName().equalsIgnoreCase(type.getCodeUnitDetails().getName());
    }
}

