/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.AnonymousClass;
import apex.jorje.semantic.ast.compilation.ParentVisibility;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.compilation.VirtualMethodsCreator;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.member.bridge.BridgeMethodCreator;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.LocalContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.ParameterContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.statement.VariableDeclarationStatements;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.InterfaceHierarchyValidator;
import apex.jorje.semantic.ast.visitor.InterfaceImplementationValidator;
import apex.jorje.semantic.ast.visitor.IsTestValidation;
import apex.jorje.semantic.ast.visitor.PostTypeResolveVisitorUtil;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PostTypeResolveVisitor
extends AstVisitor<SymbolScope> {
    private final Map<TypeInfo, LocalInfo> typeToThis;
    private final ListMultimap<TypeInfo, CompilationException> errors = ArrayListMultimap.create();

    public PostTypeResolveVisitor() {
        this.typeToThis = new HashMap<TypeInfo, LocalInfo>();
    }

    @Override
    public boolean defaultVisit() {
        return true;
    }

    @Override
    public boolean visit(AnonymousClass node, SymbolScope scope) {
        VirtualMethodsCreator.create(this.errors, scope.getSymbols(), node.getDefiningType());
        scope.getErrors().markInvalid((AstNode)node, (Collection<? extends CompilationException>)this.errors.get(node.getDefiningType()));
        return true;
    }

    @Override
    public boolean visit(UserClass node, SymbolScope scope) {
        ParentVisibility.validate(scope, node);
        VirtualMethodsCreator.create(this.errors, scope.getSymbols(), node.getDefiningType());
        scope.getErrors().markInvalid((AstNode)node, (Collection<? extends CompilationException>)this.errors.get(node.getDefiningType()));
        if (node.getDefiningType().parents().isResolved()) {
            InterfaceImplementationValidator.get().validateInterfaceImplementations(node, scope);
            PostTypeResolveVisitorUtil.validateNoStaticMethodClashes(node, scope);
        }
        return true;
    }

    @Override
    public void visitEnd(UserClass node, SymbolScope scope) {
        TypeContext context = new TypeContext(node, scope);
        PostTypeResolveVisitorUtil.validateOneAnnotationPerType(node, scope);
        node.getModifiers().validateModifiers(context);
        IsTestValidation.validate(context, node);
    }

    @Override
    public boolean visit(UserEnum node, SymbolScope scope) {
        VirtualMethodsCreator.create(this.errors, scope.getSymbols(), node.getDefiningType());
        scope.getErrors().markInvalid((AstNode)node, (Collection<? extends CompilationException>)this.errors.get(node.getDefiningType()));
        return true;
    }

    @Override
    public void visitEnd(UserEnum node, SymbolScope scope) {
        TypeContext context = new TypeContext(node, scope);
        PostTypeResolveVisitorUtil.validateOneAnnotationPerType(node, scope);
        node.getModifiers().validateModifiers(context);
    }

    @Override
    public boolean visit(UserInterface node, SymbolScope scope) {
        TypeInfo definingType = node.getDefiningType();
        ParentVisibility.validate(scope, node);
        VirtualMethodsCreator.create(this.errors, scope.getSymbols(), definingType);
        scope.getErrors().markInvalid((AstNode)node, (Collection<? extends CompilationException>)this.errors.get(definingType));
        InterfaceHierarchyValidator.get().validate(node, scope.getErrors());
        return true;
    }

    @Override
    public void visitEnd(UserInterface node, SymbolScope scope) {
        TypeContext context = new TypeContext(node, scope);
        PostTypeResolveVisitorUtil.validateOneAnnotationPerType(node, scope);
        node.getModifiers().validateModifiers(context);
    }

    @Override
    public boolean visit(UserTrigger node, SymbolScope scope) {
        VirtualMethodsCreator.create(this.errors, scope.getSymbols(), node.getDefiningType());
        scope.getErrors().markInvalid((AstNode)node, (Collection<? extends CompilationException>)this.errors.get(node.getDefiningType()));
        return true;
    }

    @Override
    public boolean visit(VariableDeclaration node, SymbolScope scope) {
        return true;
    }

    @Override
    public void visitEnd(VariableDeclaration node, SymbolScope scope) {
        node.createLocal(scope);
        LocalContext context = new LocalContext(node, scope);
        for (ModifierOrAnnotationTypeInfo modifier : node.getLocalInfo().getModifiers().all()) {
            modifier.getRuleGroup().validate(context);
        }
    }

    @Override
    public boolean visit(VariableDeclarationStatements node, SymbolScope scope) {
        node.resolveType(scope.getSymbols());
        return true;
    }

    @Override
    public boolean visit(CatchBlockStatement node, SymbolScope scope) {
        node.createLocal(scope);
        return true;
    }

    @Override
    public void visitEnd(Property node, SymbolScope scope) {
        FieldContext context = FieldContext.createProperty(node, scope);
        node.getModifiersNode().validateModifiers(context);
    }

    @Override
    public void visitEnd(Field node, SymbolScope scope) {
        FieldContext context = FieldContext.createField(node, scope);
        node.getModifiers().validateModifiers(context);
    }

    @Override
    public void visitEnd(Parameter node, SymbolScope scope) {
        ParameterContext context = new ParameterContext(node, scope);
        node.getModifiers().validateModifiers(context);
    }

    @Override
    public boolean visit(Method node, SymbolScope scope) {
        if (node.getMethodInfo().getGenerated().isUserDefined) {
            MethodContext context = new MethodContext(node, scope);
            node.getModifiersNode().validateModifiers(context);
        }
        if (!node.getMethodInfo().getModifiers().has(ModifierTypeInfos.STATIC)) {
            LocalInfo variable;
            if (this.typeToThis.containsKey(node.getMethodInfo().getDefiningType())) {
                variable = this.typeToThis.get(node.getMethodInfo().getDefiningType());
            } else {
                variable = LocalInfo.buildThis(node.getMethodInfo().getDefiningType());
                this.typeToThis.put(node.getMethodInfo().getDefiningType(), variable);
            }
            scope.getErrors().addIfError((AstNode)node, variable.getLoc(), scope.getSymbols().variables().add(variable));
        }
        for (Parameter parameter : node.getMethodInfo().getParameters()) {
            scope.getErrors().addIfError((AstNode)node, parameter.getLoc(), scope.getSymbols().variables().add(parameter.getVariable()));
        }
        return true;
    }

    @Override
    public boolean visit(BridgeMethodCreator node, SymbolScope scope) {
        node.createMethods(scope.getSymbols());
        return true;
    }

    @Override
    public void visitEnd(ModifierNode node, SymbolScope scope) {
        node.resolve();
    }
}

