/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.common.collect.MoreIterables;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.ReferenceContext;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.expression.SoslExpression;
import apex.jorje.semantic.ast.expression.SuperVariableExpression;
import apex.jorje.semantic.ast.expression.ThisVariableExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;

public class IllegalInstanceReferenceVisitor
extends AstVisitor<ValidationScope> {
    private static final VariableVisitor<Boolean, Void> IS_LOCAL = new VariableVisitor.Default<Boolean, Void>(){

        @Override
        public Boolean _default(Variable info, Void context) {
            return false;
        }

        @Override
        public Boolean visit(LocalInfo info, Void context) {
            return true;
        }
    };
    private static final IllegalInstanceReferenceVisitor INSTANCE = new IllegalInstanceReferenceVisitor();

    private IllegalInstanceReferenceVisitor() {
    }

    public static IllegalInstanceReferenceVisitor get() {
        return INSTANCE;
    }

    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public boolean visit(MethodCallExpression node, ValidationScope scope) {
        boolean isImplicitThis;
        IdentifierContext context = this.getFirstContext(node.getReferenceContext());
        boolean bl = isImplicitThis = context == IdentifierContext.NONE;
        if (node.getReferenceContext().getVariables().isEmpty() && isImplicitThis && !node.getMethod().getModifiers().has(ModifierTypeInfos.STATIC)) {
            scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("illegal.instance.method.reference.in.constructor", node.getMethod()));
            return false;
        }
        if (!node.getReferenceContext().getVariables().isEmpty()) {
            this.visitVariable(node, node.getReferenceContext().getVariables().get(0), context, scope);
        }
        return true;
    }

    @Override
    public boolean visit(VariableExpression node, ValidationScope scope) {
        return this.visitVariable(node, this.getFirstVariable(node), this.getFirstContext(node.getReferenceContext()), scope);
    }

    @Override
    public boolean visit(SoqlExpression node, ValidationScope scope) {
        return node.getDefiningType().getCodeUnitDetails().getVersion().isGreaterThanOrEqual(Version.POST_RELEASE);
    }

    @Override
    public boolean visit(SoslExpression node, ValidationScope scope) {
        return node.getDefiningType().getCodeUnitDetails().getVersion().isGreaterThanOrEqual(Version.POST_RELEASE);
    }

    @Override
    public boolean visit(SuperVariableExpression node, ValidationScope scope) {
        scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "super"));
        return false;
    }

    @Override
    public boolean visit(ThisVariableExpression node, ValidationScope scope) {
        scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", "this"));
        return false;
    }

    private Variable getFirstVariable(VariableExpression expression) {
        return MoreIterables.getFirst(expression.getReferenceContext().getVariables(), expression.getVariable());
    }

    private IdentifierContext getFirstContext(ReferenceContext expression) {
        return expression.getContexts().stream().map(input -> input.previous).findFirst().orElse(expression.getContext());
    }

    private boolean visitVariable(AstNode node, Variable variable, IdentifierContext context, ValidationScope scope) {
        boolean isImplicitThis;
        boolean isLocal = variable.accept(IS_LOCAL, VariableVisitor.Context.NONE);
        boolean bl = isImplicitThis = context == IdentifierContext.NONE;
        if (!isLocal && isImplicitThis && !variable.getModifiers().has(ModifierTypeInfos.STATIC)) {
            scope.getErrors().markInvalid(node, I18nSupport.getLabel("illegal.instance.variable.reference.in.constructor", variable.getName()));
            return false;
        }
        return true;
    }
}

