/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement.foreachstatement;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.ForControl;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.LoopStack;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.ForEachInitFactory;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.foreachstatement.ListCreator;
import apex.jorje.semantic.ast.statement.foreachstatement.ListCreatorVisitors;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.DatabaseEmitMethods;
import apex.jorje.semantic.bcl.IteratorEmitMethods;
import apex.jorje.semantic.bcl.ListEmitMethods;
import apex.jorje.semantic.bcl.NewObjectHelperEmitMethods;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.bcl.SObjectEmitMethods;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.services.I18nSupport;
import java.util.Objects;
import org.objectweb.asm.Label;

public class ForEachStatement
extends Statement {
    private final Expression list;
    private final ForEachInitFactory.ForEachVariable variable;
    private final Location loc;
    private final BlockStatement bodyStatement;
    private final LocalVariableScope locals;
    private final boolean hasBlock;
    private GenericTypeInfo listType;
    private TypeInfo loopVariableType;
    private ListCreator listCreator;

    public ForEachStatement(AstNode definingNode, Stmnt.ForLoop stmnt, ForControl.EnhancedForControl forControl) {
        super(definingNode);
        this.variable = ForEachInitFactory.create(this, forControl);
        this.list = AstNodes.get().create((AstNode)this, (Expr)forControl.init.expr.orElse(null));
        this.loc = stmnt.loc;
        this.bodyStatement = BlockStatement.builder().setDefiningNode(this).setStmnt(stmnt.stmnt).build();
        this.locals = new LocalVariableScope();
        this.hasBlock = stmnt.stmnt.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                this.list.traverse(visitor, scope);
                scope.push(this.bodyStatement);
                try {
                    this.variable.declaration.traverse(visitor, scope);
                    this.variable.expression.traverse(visitor, scope);
                    this.bodyStatement.traverse(visitor, scope);
                }
                finally {
                    scope.pop(this.bodyStatement);
                }
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            this.list.validate(symbols, scope);
            scope.push(this.bodyStatement);
            try {
                this.variable.declaration.validate(symbols, scope);
                if (!scope.getErrors().isInvalid(this.variable.declaration)) {
                    this.variable.expression.validate(symbols, scope);
                }
                this.bodyStatement.validate(symbols, scope);
            }
            finally {
                scope.pop(this.bodyStatement);
            }
            if (scope.getErrors().isInvalid(this.variable.declaration, this.variable.expression, this.list, this.bodyStatement)) {
                scope.getErrors().markInvalid(this);
                return;
            }
            if (!CollectionTypeInfoUtil.isCollection(this.list.getType())) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("loop.must.iterate.over.collection", this.list.getType()));
                return;
            }
            this.listCreator = ListCreator.createListCreatorEnum(this.list, ListCreatorVisitors.INSTANCE);
            this.listType = (GenericTypeInfo)this.list.getType();
            this.loopVariableType = this.variable.expression.getType();
            TypeInfo listElementType = CollectionTypeInfoUtil.getElementType(this.listType);
            if (this.listCreator.isQueryBased()) {
                if (!this.hasBlock) {
                    scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("loop.with.query.requires.statement"));
                }
                if (SObjectTypeInfoUtil.isConcreteSObjectList(this.listType)) {
                    TypeInfo innerElementType;
                    TypeInfo typeInfo = innerElementType = CollectionTypeInfoUtil.isList(this.loopVariableType) ? CollectionTypeInfoUtil.getElementType(this.loopVariableType) : this.loopVariableType;
                    if (!(TypeInfoEquivalence.isEquivalent(innerElementType, TypeInfos.SOBJECT) || SObjectTypeInfoUtil.isGenericSObjectList(this.loopVariableType) || TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getElementType(this.listType), innerElementType))) {
                        scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("loop.variable.mismatch.concrete.sobject.type", CollectionTypeInfoUtil.getElementType(this.listType)));
                    }
                } else if (this.loopVariableType.getBasicType() != BasicType.SOBJECT && !SObjectTypeInfoUtil.isSObjectList(this.loopVariableType)) {
                    scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("loop.variable.mismatch.sobject.type"));
                }
            } else if (!Distance.get().canAssign(this.getDefiningType(), listElementType, this.loopVariableType)) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.loop.type", listElementType, this.loopVariableType));
            }
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        IteratorInfo iterator;
        boolean isChunkIterator = this.isChunkIterator();
        LoopStack loopStack = emitter.getLoopStack();
        LoopStack.LoopContext loop = new LoopStack.LoopContext(emitter, this.bodyStatement.getLoc(), this.getLoc());
        loop.emitIterationCounter();
        boolean isAggregateQuery = false;
        switch (this.listCreator) {
            case SET: {
                iterator = IteratorInfo.builder().setIsQueryResult(false).setIsChunkIterator(isChunkIterator).setListType(this.listType).build();
                if (emitter.enforceNewEmitBehavior()) {
                    emitter.push(this.loc, TypeEraser.eraseBytecodeName(GenericTypeInfoFactory.createList(CollectionTypeInfoUtil.getElementType(this.listType)), TypeEraser.CustomErasureType.REGULAR));
                    emitter.emit(this.loc, NewObjectHelperEmitMethods.newList());
                    emitter.emitType(this.loc, 192, iterator.iteratorDefiningType);
                    emitter.emit(this.loc, 89);
                } else {
                    emitter.emitType(this.getLoc(), 187, iterator.iteratorDefiningType);
                    emitter.emit(this.loc, 89);
                    emitter.emit(this.loc, ObjectEmitMethods.constructor(iterator.iteratorDefiningType));
                    emitter.emit(this.loc, 89);
                }
                this.list.emit(emitter);
                emitter.emit(this.getLoc(), ListEmitMethods.addAll(TypeInfos.LIST));
                break;
            }
            case SOQL_EXPRESSION: {
                SoqlExpression soql = ExpressionUtil.getSoqlExpression(this.list);
                isAggregateQuery = soql.isAggregateQuery();
                soql.getBindExpression().emit(emitter);
                emitter.push(Locations.NONE, true);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.push(Locations.NONE, isChunkIterator);
                emitter.box(TypeInfos.BOOLEAN);
                ProfilingType.SOQL.emit(emitter, this.getLoc(), soql.getQuery());
                emitter.emit(Locations.NONE, DatabaseEmitMethods.GET_QUERY_LOCATOR);
                iterator = IteratorInfo.builder().setIsQueryResult(true).setIsChunkIterator(isChunkIterator).build();
                break;
            }
            case SOQL_DOTTED_EXPRESSION: 
            case AGGREGATE_FIELD: {
                this.list.emit(emitter);
                iterator = IteratorInfo.builder().setIsQueryResult(true).setIsDottedQueryResult().setIsChunkIterator(isChunkIterator).build();
                break;
            }
            case DATABASE_QUERY: {
                MethodCallExpression databaseQueryCall = ExpressionUtil.getMethodCallExpression(this.list);
                databaseQueryCall.getInputParameters().get(0).emit(emitter);
                emitter.emit(Locations.NONE, 1);
                emitter.push(Locations.NONE, true);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.push(Locations.NONE, isChunkIterator);
                emitter.box(TypeInfos.BOOLEAN);
                ProfilingType.METHOD.emit(emitter, databaseQueryCall);
                emitter.emit(Locations.NONE, DatabaseEmitMethods.GET_QUERY_LOCATOR);
                iterator = IteratorInfo.builder().setIsQueryResult(true).setIsChunkIterator(isChunkIterator).build();
                break;
            }
            case SYSTEM_DATABASE_QUERY: {
                MethodCallExpression systemDatabaseQueryCall = ExpressionUtil.getMethodCallExpression(this.list);
                systemDatabaseQueryCall.getInputParameters().get(0).emit(emitter);
                ProfilingType.SOQL.emit(emitter, systemDatabaseQueryCall);
                emitter.emit(this.getLoc(), DatabaseEmitMethods.QUERY);
                iterator = IteratorInfo.builder().setIsQueryResult(false).setListType(ReifiedTypeInfos.SOBJECT_LIST).setIsChunkIterator(isChunkIterator).build();
                break;
            }
            case GET_SOBJECTS: {
                MethodCallExpression getSObjectsCall = ExpressionUtil.getMethodCallExpression(this.list);
                MethodInfo method = getSObjectsCall.getMethod();
                assert (method.getParameters().size() == 1);
                assert (method.getParameters().get(0).getType().equals(TypeInfos.STRING) || TypeInfoEquivalence.isEquivalent(InternalTypeInfos.SCHEMA_SOBJECT_FIELD, method.getParameters().get(0).getType()));
                getSObjectsCall.emitReferenceExpression(emitter);
                getSObjectsCall.getInputParameters().get(0).emit(emitter);
                if (Objects.equals(method.getParameters().get(0).getType(), TypeInfos.STRING)) {
                    emitter.emit(this.loc, SObjectEmitMethods.getSObjectsSelectLoop(TypeInfos.STRING));
                } else if (TypeInfoEquivalence.isEquivalent(InternalTypeInfos.SCHEMA_SOBJECT_FIELD, method.getParameters().get(0).getType())) {
                    emitter.emit(this.loc, SObjectEmitMethods.getSObjectsSelectLoop(TypeInfos.OBJECT));
                } else {
                    throw new UnexpectedCodePathException();
                }
                iterator = IteratorInfo.builder().setIsQueryResult(true).setIsChunkIterator(isChunkIterator).build();
                break;
            }
            case LIST: {
                this.list.emit(emitter);
                iterator = IteratorInfo.builder().setIsQueryResult(false).setIsChunkIterator(isChunkIterator).setListType(this.listType).build();
                break;
            }
            default: {
                throw new UnexpectedCodePathException();
            }
        }
        if (iterator.requiresSystemMode()) {
            int index = emitter.getMethodStack().peek().getLocalVariables().add();
            emitter.emit(Locations.NONE, 89);
            emitter.emitVar(this.loc, 58, index);
            emitter.getTryCatchFinallyStack().push(this.getFinallyEmitter(index));
            emitter.getTryCatchFinallyStack().startTryBlock();
        }
        if (isChunkIterator) {
            emitter.push(this.getLoc(), isAggregateQuery);
            emitter.box(TypeInfos.BOOLEAN);
            emitter.emit(this.loc, ListEmitMethods.chunkIterator(iterator.iteratorDefiningType, iterator.iteratorReturnType));
        } else {
            emitter.emit(this.loc, ListEmitMethods.iterator(iterator.iteratorDefiningType, iterator.iteratorReturnType));
        }
        int iteratorVariable = emitter.getMethodStack().peek().getLocalVariables().add();
        emitter.emitVar(this.loc, 58, iteratorVariable);
        loop.setTryStackSize();
        loopStack.push(loop);
        Label start = new Label();
        emitter.emit(start);
        loop.emitContinueLabel();
        emitter.emitVar(this.loc, 25, iteratorVariable);
        emitter.emit(Locations.NONE, IteratorEmitMethods.hasNext(iterator.iteratorReturnType));
        emitter.unbox(TypeInfos.BOOLEAN);
        Label exit = new Label();
        emitter.emitJump(Locations.NONE, 153, exit);
        emitter.emitVar(this.loc, 25, iteratorVariable);
        emitter.emit(Locations.NONE, IteratorEmitMethods.next(iterator.iteratorReturnType, iterator.elementType));
        if (!TypeInfoEquivalence.isEquivalent(this.loopVariableType, TypeInfos.OBJECT)) {
            String bytecodeName;
            emitter.emit(Locations.NONE, 89);
            if (emitter.enforceNewEmitBehavior()) {
                bytecodeName = TypeEraser.eraseBytecodeName(this.loopVariableType, TypeEraser.CustomErasureType.UNION_SUB_ENTITY);
                emitter.push(Locations.NONE, bytecodeName);
                emitter.emit(Locations.NONE, SystemEmitMethods.VALIDATE_VARIABLE_TYPE_FOR_SELECT_LOOP);
                emitter.push(Locations.NONE, bytecodeName);
                emitter.emit(Locations.NONE, SystemEmitMethods.CONVERT);
            } else {
                bytecodeName = TypeEraser.eraseBytecodeName(this.loopVariableType);
                emitter.push(Locations.NONE, bytecodeName);
                emitter.emit(Locations.NONE, SystemEmitMethods.VALIDATE_VARIABLE_TYPE_FOR_SELECT_LOOP);
                emitter.push(Locations.NONE, bytecodeName);
                emitter.emit(Locations.NONE, SystemEmitMethods.CONVERT);
            }
        }
        this.variable.expression.emit(emitter);
        loop.emitIterationCounterIncrement();
        this.bodyStatement.emit(emitter);
        emitter.emitJump(this.bodyStatement.getLoc(), 167, start);
        emitter.emit(exit);
        LoopStack.LoopContext sanity = loopStack.pop();
        assert (loop == sanity);
        emitter.emit(this.loc, 1);
        emitter.emitVar(this.loc, 58, iteratorVariable);
        emitter.emit(this.loc, 1);
        this.variable.expression.emit(emitter);
        loop.emitZeroIterationCounter();
        if (iterator.requiresSystemMode()) {
            emitter.getTryCatchFinallyStack().endBlock();
            emitter.getTryCatchFinallyStack().pop(Emit.NOOP);
        }
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    private Emit getFinallyEmitter(int index) {
        return emitter -> {
            emitter.emitVar(this.loc, 25, index);
            emitter.emit(Locations.NONE, SystemEmitMethods.REMOVE_KEEP_ALIVE_CURSOR);
            emitter.emit(this.loc, 1);
            emitter.emitVar(this.loc, 58, index);
        };
    }

    private boolean isChunkIterator() {
        if (CollectionTypeInfoUtil.isCollection(this.listType)) {
            TypeInfo listElementType = CollectionTypeInfoUtil.getElementType(this.listType);
            if (TypeInfoEquivalence.isEquivalent(listElementType, this.loopVariableType)) {
                return false;
            }
            if (CollectionTypeInfoUtil.isList(this.loopVariableType)) {
                TypeInfo loopVariableElementType = CollectionTypeInfoUtil.getElementType(this.loopVariableType);
                return Distance.get().canAssign(this.getDefiningType(), listElementType, loopVariableElementType) || loopVariableElementType.getBasicType() == BasicType.SOBJECT && SObjectTypeInfoUtil.isGenericSObjectList(this.listType);
            }
        }
        return false;
    }

    public LocalVariableScope getLocals() {
        return this.locals;
    }

    private static class IteratorInfo {
        private final boolean isQueryResult;
        private final TypeInfo iteratorReturnType;
        private final TypeInfo elementType;
        private final String iteratorDefiningType;
        private final boolean isDottedQueryResult;

        private IteratorInfo(Builder builder) {
            this.isQueryResult = builder.isQueryResult;
            this.iteratorReturnType = builder.iteratorReturnType;
            this.elementType = builder.elementType;
            this.iteratorDefiningType = builder.iteratorDefiningType;
            this.isDottedQueryResult = builder.isDottedQueryResult;
        }

        private static Builder builder() {
            return new Builder();
        }

        private boolean requiresSystemMode() {
            return this.isQueryResult && !this.isDottedQueryResult;
        }

        private static class Builder {
            private boolean isQueryResult;
            private boolean isChunkIterator;
            private String iteratorDefiningType;
            private TypeInfo elementType;
            private InternalTypeInfo iteratorReturnType;
            private GenericTypeInfo oldListType;
            private boolean isDottedQueryResult;

            private Builder() {
            }

            private IteratorInfo build() {
                if (this.isQueryResult) {
                    if (this.isChunkIterator) {
                        this.iteratorReturnType = InternalTypeInfos.DATABASE_QUERY_LOCATOR_CHUNK_ITERATOR;
                        this.elementType = TypeInfos.OBJECT;
                    } else {
                        this.iteratorReturnType = InternalTypeInfos.DATABASE_QUERY_LOCATOR_ITERATOR;
                        this.elementType = TypeInfos.SOBJECT;
                    }
                } else {
                    this.iteratorReturnType = InternalTypeInfos.SYSTEM_ITERATOR;
                    this.elementType = TypeInfos.OBJECT;
                }
                if (this.isQueryResult) {
                    this.iteratorDefiningType = InternalTypeInfos.DATABASE_QUERY_LOCATOR.getBytecodeName();
                } else if (CollectionTypeInfoUtil.isSet(this.oldListType)) {
                    TypeInfo elementType = CollectionTypeInfoUtil.getElementType(this.oldListType);
                    this.iteratorDefiningType = TypeNameUtil.createBytecodeName(TypeInfos.LIST.getBytecodeName(), TypeEraser.eraseBytecodeName(elementType));
                } else {
                    this.iteratorDefiningType = TypeEraser.eraseBytecodeName(this.oldListType);
                }
                return new IteratorInfo(this);
            }

            private Builder setIsQueryResult(boolean isQueryResult) {
                this.isQueryResult = isQueryResult;
                return this;
            }

            private Builder setIsChunkIterator(boolean isChunkIterator) {
                this.isChunkIterator = isChunkIterator;
                return this;
            }

            private Builder setListType(GenericTypeInfo listType) {
                this.oldListType = listType;
                return this;
            }

            private Builder setIsDottedQueryResult() {
                this.isDottedQueryResult = true;
                return this;
            }
        }
    }
}

