/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.DoLoopStatement;
import apex.jorje.semantic.ast.statement.ForLoopStatement;
import apex.jorje.semantic.ast.statement.IfBlockStatement;
import apex.jorje.semantic.ast.statement.IfElseBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.TryCatchFinallyBlockStatement;
import apex.jorje.semantic.ast.statement.WhileLoopStatement;
import apex.jorje.semantic.ast.statement.foreachstatement.ForEachStatement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.BooleanScope;
import com.google.common.collect.Iterables;

final class StatementUtil {
    private static final AstVisitor<BooleanScope> IS_LAST_STATEMENT_RETURNABLE = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(BlockStatement node, BooleanScope scope) {
            if (!node.getStatements().isEmpty()) {
                Statement statement = Iterables.getLast(node.getStatements());
                scope.setValue(scope.getValue() && statement.isReturnable());
                statement.traverse(this, scope);
            }
        }

        @Override
        public boolean visit(DoLoopStatement node, BooleanScope scope) {
            return scope.getValue();
        }

        @Override
        public boolean visit(ForEachStatement node, BooleanScope scope) {
            return scope.getValue();
        }

        @Override
        public boolean visit(ForLoopStatement node, BooleanScope scope) {
            return scope.getValue();
        }

        @Override
        public boolean visit(IfBlockStatement node, BooleanScope scope) {
            return scope.getValue();
        }

        @Override
        public boolean visit(IfElseBlockStatement node, BooleanScope scope) {
            return scope.getValue();
        }

        @Override
        public boolean visit(WhileLoopStatement node, BooleanScope scope) {
            return scope.getValue();
        }

        @Override
        public boolean visit(CatchBlockStatement node, BooleanScope scope) {
            return scope.getValue();
        }

        @Override
        public void visitEnd(TryCatchFinallyBlockStatement node, BooleanScope scope) {
            node.getTryBlock().traverse(this, scope);
            for (CatchBlockStatement catchBlock : node.getCatchBlocks()) {
                catchBlock.traverse(this, scope);
            }
        }
    };

    private StatementUtil() {
    }

    static boolean isLastStatementReturnable(Statement statement) {
        return BooleanScope.evaluate(statement, IS_LAST_STATEMENT_RETURNABLE, statement.isReturnable());
    }
}

