/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.common.collect.MoreIterables;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.IfBlock;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.IfBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.StatementExecuted;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import com.google.common.collect.MoreLists;
import java.util.List;
import org.objectweb.asm.Label;

public class IfElseBlockStatement
extends Statement {
    private final List<IfBlockStatement> ifBlockStatements;
    private final Statement elseStatement;
    private final Location loc;
    private final List<Statement> statements;
    private final LocalVariableScope locals;
    private Label exit;

    public IfElseBlockStatement(AstNode definingNode, Stmnt.IfElseBlock stmnt) {
        super(definingNode);
        this.loc = Locations.from(stmnt);
        this.ifBlockStatements = AstNodes.filterNullTransform(stmnt.ifBlocks, ifBlock -> new IfBlockStatement(this, (IfBlock)ifBlock));
        this.elseStatement = stmnt.elseBlock.map(value -> {
            if (value.stmnt == null) {
                return BlockStatement.builder().setDefiningNode(this).setStatement(Statement.INVALID).build();
            }
            return BlockStatement.builder().setDefiningNode(this).setStmnt(value.stmnt).build();
        }).orElse(BlockStatement.builder().setDefiningNode(this).setStatement(StatementExecuted.createReal(this, this.loc, true, true)).build());
        this.statements = MoreLists.appendList(this.ifBlockStatements, this.elseStatement);
        if (MoreIterables.ensureAll(this.statements, Statement::isReturnable)) {
            this.setReturnable();
        }
        this.locals = new LocalVariableScope();
        this.exit = new Label();
    }

    public LocalVariableScope getLocals() {
        return this.locals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                for (Statement statement : this.statements) {
                    statement.traverse(visitor, scope);
                }
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            for (Statement statement : this.statements) {
                statement.validate(symbols, scope);
            }
            Errors errors = scope.getErrors();
            if (errors.isInvalid(this.ifBlockStatements) || errors.isInvalid(this.elseStatement)) {
                errors.markInvalid(this);
            }
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        for (IfBlockStatement ifBlockStatement : this.ifBlockStatements) {
            ifBlockStatement.emit(emitter);
        }
        this.elseStatement.emit(emitter);
        emitter.emit(this.exit);
        this.exit = new Label();
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public Label getExit() {
        return this.exit;
    }
}

