/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.CatchBlock;
import apex.jorje.data.ast.ParameterRef;
import apex.jorje.data.ast.ParameterRefs;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TryCatchFinallyStack;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.TryCatchFinallyBlockStatement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import apex.jorje.services.I18nSupport;

public class CatchBlockStatement
extends Statement {
    private final Location loc;
    private final ParameterRef exception;
    private final Statement statement;
    private final LocalVariableScope locals;
    private LocalInfo variable;

    CatchBlockStatement(TryCatchFinallyBlockStatement definingNode, CatchBlock catchBlock) {
        super(definingNode);
        this.loc = Locations.from(catchBlock.stmnt);
        this.exception = catchBlock.parameter;
        this.statement = AstNodes.get().create((AstNode)this, catchBlock.stmnt);
        this.locals = new LocalVariableScope();
        this.setReturnable(this.statement);
    }

    public TypeRef getTypeRef() {
        return this.exception.getType();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                this.statement.traverse(visitor, scope);
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            this.statement.validate(symbols, scope);
            Errors errors = scope.getErrors();
            if (errors.isInvalid(this.statement)) {
                errors.markInvalid(this);
            }
            if (ParameterRefs.isInvalidParameterRef(this.exception)) {
                errors.markInvalid(this);
                return;
            }
            if (!this.variable.getType().isResolved()) {
                errors.markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.variable.getType()));
            } else if (!ExceptionTypeInfoUtil.isException(this.getDefiningType(), this.variable.getType())) {
                errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.catch.exception", this.variable.getType()));
            }
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        TryCatchFinallyStack.TryCatchFinallyContext context = emitter.getTryCatchFinallyStack().peek();
        emitter.getTryCatchFinallyStack().startCatchBlock();
        TryCatchFinallyBlockStatement.UNCATCHABLE_EXCEPTION.emit(emitter);
        emitter.emitVar(this.loc, 58, this.variable.getPosition(emitter));
        this.statement.emit(emitter);
        TryCatchFinallyStack.Block block = emitter.getTryCatchFinallyStack().endBlock();
        emitter.emitJump(Locations.NONE, 167, context.getExit());
        emitter.emitCatchBlock(context.getTryStartForCatch(), context.getTryBlock().getEnd(), block.getStart(), this.variable.getType());
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public void createLocal(SymbolScope scope) {
        if (ParameterRefs.isInvalidParameterRef(this.exception)) {
            return;
        }
        ModifierGroup modifiers = ModifierGroup.builder().setLoc(this.exception.getName().getLoc()).addAstModifiers(this.exception.getModifiers()).addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).build();
        TypeInfo type = this.exception.getType() == null ? UnresolvedTypeInfoFactory.get() : scope.getSymbols().lookupTypeInfo(this.getDefiningType(), this.exception.getType());
        this.variable = LocalInfo.builder().setName(this.exception.getName().getValue()).setDefiningType(this.getDefiningType()).setType(type).setModifiers(modifiers).build();
        scope.getErrors().addIfError((AstNode)this, this.exception.getName().getLoc(), scope.getSymbols().variables().add(this.variable));
    }

    public LocalInfo getVariable() {
        return this.variable;
    }

    public LocalVariableScope getLocals() {
        return this.locals;
    }
}

