/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRuleUtil;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;

public class InvocableContextRule
implements AnnotationContextRule {
    private static final InvocableContextRule INSTANCE = new InvocableContextRule();
    static final TypeInfoVisitor<Boolean> METHOD_VISITOR = new TypeInfoVisitor.Default<Boolean>(){

        @Override
        protected Boolean _default(TypeInfo type) {
            return false;
        }

        private Boolean visitUserType(TypeInfo type) {
            if (type.getModifiers().none(ModifierTypeInfos.GLOBAL, ModifierTypeInfos.PUBLIC)) {
                return false;
            }
            for (FieldInfo field : type.fields().all()) {
                if (!field.getModifiers().has(AnnotationTypeInfos.INVOCABLE_VARIABLE)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visit(SObjectTypeInfo type) {
            return true;
        }

        @Override
        public Boolean visit(StandardTypeInfo type) {
            return this.visitUserType(type);
        }

        @Override
        public Boolean visit(GenericTypeInfo type) {
            return InvocableContextRule.isAtMostTwoNestedLists(type, this);
        }

        @Override
        public Boolean visit(ScalarTypeInfo type) {
            return type.getBasicType().isScalarOrVoid();
        }

        @Override
        public Boolean visit(InternalTypeInfo type) {
            throw new UnsupportedOperationException();
        }
    };
    static final TypeInfoVisitor<Boolean> FIELD_VISITOR = new TypeInfoVisitor.Default<Boolean>(){

        @Override
        protected Boolean _default(TypeInfo type) {
            return false;
        }

        @Override
        public Boolean visit(SObjectTypeInfo type) {
            return true;
        }

        @Override
        public Boolean visit(StandardTypeInfo type) {
            return false;
        }

        @Override
        public Boolean visit(GenericTypeInfo type) {
            return InvocableContextRule.isAtMostTwoNestedLists(type, this);
        }

        @Override
        public Boolean visit(ScalarTypeInfo type) {
            return type.getBasicType().isScalarOrVoid();
        }

        @Override
        public Boolean visit(InternalTypeInfo type) {
            throw new UnsupportedOperationException();
        }
    };

    private InvocableContextRule() {
    }

    static boolean isAtMostTwoNestedLists(TypeInfo type, TypeInfoVisitor<Boolean> visitor) {
        if (CollectionTypeInfoUtil.isList(type)) {
            TypeInfo elementType = CollectionTypeInfoUtil.getElementType(type);
            if (CollectionTypeInfoUtil.isList(elementType)) {
                TypeInfo elementsElementType = CollectionTypeInfoUtil.getElementType(elementType);
                if (CollectionTypeInfoUtil.isList(elementsElementType)) {
                    return false;
                }
                return elementsElementType.accept(visitor);
            }
            return elementType.accept(visitor);
        }
        return false;
    }

    public static InvocableContextRule get() {
        return INSTANCE;
    }

    @Override
    public void validate(MethodContext context) {
        MethodInfo method = context.getMethodInfo();
        if (method.getModifiers().getAnnotations().size() == 2 && method.getModifiers().not(AnnotationTypeInfos.DEPRECATED) || method.getModifiers().getAnnotations().size() > 2 || method.getModifiers().isTest()) {
            context.addNodeError(I18nSupport.getLabel("invocable.method.can.only.have.deprecated"));
        }
        if (!method.getParameters().isEmpty()) {
            if (method.getParameters().size() > 1) {
                context.addNodeError(I18nSupport.getLabel("invocable.method.single.param"));
                return;
            }
            if (method.getParameters().get(0).getType().getBasicType() != BasicType.LIST) {
                context.addNodeError(I18nSupport.getLabel("invocable.method.non.list.parameter", method.getParameters().get(0).getType()));
                return;
            }
        }
        if (method.getReturnType().getBasicType() != BasicType.LIST && method.getReturnType().getBasicType() != BasicType.VOID) {
            context.addNodeError(I18nSupport.getLabel("method.does.not.support.return.type", AnnotationTypeInfos.INVOCABLE_METHOD, method.getReturnType()));
            return;
        }
        AnnotationRuleUtil.validate(context, AnnotationTypeInfos.INVOCABLE_METHOD, METHOD_VISITOR, METHOD_VISITOR);
    }

    @Override
    public void validate(FieldContext context) {
        AnnotationRuleUtil.validate(context, AnnotationTypeInfos.INVOCABLE_VARIABLE, FIELD_VISITOR);
    }

    @Override
    public void validate(TypeContext context) {
        throw new UnexpectedCodePathException();
    }
}

