/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.common.collect.MoreIterables;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.AnnotationVisitor;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.Annotation;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierOrAnnotation;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContext;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import org.objectweb.asm.AnnotationVisitor;

public class ModifierNode
implements AstNode {
    @VisibleForTesting
    static final String DEVELOPER_NAME = "developerName";
    @VisibleForTesting
    static final String LINE = "line";
    @VisibleForTesting
    static final String COLUMN = "column";
    private final TypeInfo definingType;
    private final ModifierGroup modifiers;

    public ModifierNode(AstNode definingNode, ModifierGroup modifiers) {
        this(definingNode.getDefiningType(), modifiers);
    }

    public ModifierNode(TypeInfo definingType, ModifierGroup modifiers) {
        this.definingType = definingType;
        this.modifiers = modifiers;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (Annotation annotation : this.modifiers.getAnnotations()) {
                annotation.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        for (ModifierOrAnnotation annotation : this.modifiers.allNodes()) {
            annotation.validate(symbols, scope);
        }
        if (scope.getErrors().isInvalid(this.modifiers.allNodes())) {
            scope.getErrors().markInvalid(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        AnnotationVisitor.VisitorContext visitor = emitter.getAnnotationVisitor().get();
        if (!this.needsEmitting(visitor)) {
            return;
        }
        ArrayList<ModifierOrAnnotation> allNodes = new ArrayList<ModifierOrAnnotation>(this.modifiers.allNodes().size());
        for (ModifierOrAnnotation modifierOrAnnotation : this.modifiers.allNodes()) {
            allNodes.add(modifierOrAnnotation);
        }
        allNodes.sort(ModifierOrAnnotation.NAME_COMPARATOR);
        for (ModifierOrAnnotation modifierOrAnnotation : allNodes) {
            modifierOrAnnotation.emit(emitter);
        }
        AnnotationVisitor av = visitor.getAnnotationVisitor();
        Location loc = this.modifiers.getLoc();
        if (Locations.isReal(loc)) {
            av.visit(LINE, (Object)loc.getLine());
            av.visit(COLUMN, (Object)loc.getColumn());
        }
        if (visitor.getDeveloperName() != null) {
            av.visit(DEVELOPER_NAME, (Object)visitor.getDeveloperName());
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    private boolean needsEmitting(AnnotationVisitor.VisitorContext visitor) {
        return MoreIterables.ensureAny(this.modifiers.all(), ModifierOrAnnotationTypeInfo::isBytecodeVisible) || visitor.getDeveloperName() != null || Locations.isReal(this.modifiers.getLoc());
    }

    @Override
    public Location getLoc() {
        return this.modifiers.getLoc();
    }

    public void resolve() {
        for (Annotation annotation : this.modifiers.getAnnotations()) {
            annotation.resolve(this.definingType.getCodeUnitDetails().getVersion());
            for (AnnotationParameter parameter : annotation.getParameters()) {
                parameter.resolve();
            }
        }
        this.modifiers.resolve();
    }

    public void validateModifiers(AnnotationContext context) {
        for (ModifierOrAnnotationTypeInfo modifier : this.modifiers.all()) {
            modifier.getRuleGroup().validate(context);
        }
        for (Annotation annotation : this.modifiers.getAnnotations()) {
            for (AnnotationParameter annotationParameter : annotation.getParameters()) {
                annotationParameter.validate(context);
            }
        }
        this.validateMultipleScopes(context);
    }

    private void validateMultipleScopes(AnnotationContext context) {
        if (Version.V172.isGreaterThan(context.getDefiningType().getCodeUnitDetails().getVersion())) {
            return;
        }
        int scopeCount = 0;
        if (this.modifiers.has(ModifierTypeInfos.GLOBAL)) {
            ++scopeCount;
        }
        if (this.modifiers.has(ModifierTypeInfos.PUBLIC)) {
            ++scopeCount;
        }
        if (this.modifiers.has(ModifierTypeInfos.PRIVATE)) {
            ++scopeCount;
        }
        if (scopeCount > 1) {
            context.addError(I18nSupport.getLabel("declarations.single.scope"));
        }
    }

    public ModifierGroup getModifiers() {
        return this.modifiers;
    }
}

