/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.data.Locatable;
import apex.jorje.data.Location;
import apex.jorje.semantic.ast.modifier.Annotation;
import apex.jorje.semantic.ast.modifier.Modifier;
import apex.jorje.semantic.ast.modifier.ModifierGroupBuilder;
import apex.jorje.semantic.ast.modifier.ModifierOrAnnotation;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.StandardAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.visitor.ModifierOrAnnotationVisitor;
import com.google.common.base.Equivalence;
import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModifierGroup
implements Locatable {
    private static final Interner<List<Modifier>> MODIFIERS_INTERNER = Interners.newWeakInterner();
    private static final Interner<Set<ModifierOrAnnotationTypeInfo>> MODIFIER_TYPES_INTERNER = Interners.newWeakInterner();
    private final Location loc;
    private final int javaModifiers;
    private final List<Annotation> annotations;
    private final List<Modifier> modifiers;
    private final Map<Equivalence.Wrapper<TypeInfo>, ModifierOrAnnotation> all;
    private final Supplier<Set<ModifierOrAnnotationTypeInfo>> allTypes;
    private Set<ModifierOrAnnotationTypeInfo> duplicates;
    private boolean resolved;

    ModifierGroup(ModifierGroupBuilder builder) {
        this.loc = builder.getLoc();
        this.javaModifiers = builder.getJavaModifiers();
        this.annotations = builder.getAnnotations();
        this.modifiers = MODIFIERS_INTERNER.intern(builder.getModifiers());
        this.all = new LinkedHashMap<Equivalence.Wrapper<TypeInfo>, ModifierOrAnnotation>();
        this.duplicates = ImmutableSet.of();
        this.allTypes = Suppliers.memoize(new AllSupplier(this.all));
        this.resolve(this.modifiers);
        this.resolved = this.annotations.isEmpty();
    }

    public static ModifierGroupBuilder builder() {
        return new ModifierGroupBuilder();
    }

    private void resolve(List<? extends ModifierOrAnnotation> modifierOrAnnotations) {
        for (ModifierOrAnnotation modifierOrAnnotation : modifierOrAnnotations) {
            assert (modifierOrAnnotation.getType() != null);
            if (this.all.containsKey(modifierOrAnnotation.getType().getEquivalenceWrapper())) {
                if (this.duplicates.isEmpty()) {
                    this.duplicates = new LinkedHashSet<ModifierOrAnnotationTypeInfo>();
                }
                this.duplicates.add(modifierOrAnnotation.getType());
                continue;
            }
            this.all.put(modifierOrAnnotation.getType().getEquivalenceWrapper(), modifierOrAnnotation);
        }
    }

    public int getJavaModifiers() {
        return this.javaModifiers;
    }

    public boolean has(ModifierOrAnnotationTypeInfo modifier) {
        assert (this.assertIsResolvedForInput(modifier)) : "modifier is not resolved";
        return this.all.containsKey(modifier.getEquivalenceWrapper());
    }

    public boolean all(ModifierOrAnnotationTypeInfo modifier1, ModifierOrAnnotationTypeInfo modifier2) {
        return this.has(modifier1) && this.has(modifier2);
    }

    public boolean some(ModifierOrAnnotationTypeInfo modifier1, ModifierOrAnnotationTypeInfo modifier2) {
        return this.has(modifier1) || this.has(modifier2);
    }

    public boolean not(ModifierOrAnnotationTypeInfo modifier) {
        return !this.has(modifier);
    }

    public boolean none(ModifierOrAnnotationTypeInfo modifier1, ModifierOrAnnotationTypeInfo modifier2) {
        return this.not(modifier1) && this.not(modifier2);
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean isTest() {
        return this.some(ModifierTypeInfos.TEST_METHOD, AnnotationTypeInfos.IS_TEST);
    }

    public boolean isTestOrTestSetup() {
        return this.some(ModifierTypeInfos.TEST_METHOD, AnnotationTypeInfos.IS_TEST) || this.has(AnnotationTypeInfos.TEST_SETUP);
    }

    public ModifierGroup resolve() {
        if (!this.resolved) {
            this.resolve(this.annotations);
        }
        this.resolved = true;
        return this;
    }

    public ModifierGroupBuilder copy() {
        return new ModifierGroupBuilder().setLoc(this.loc).addModifiers(this.modifiers).addAnnotations(this.annotations);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("loc", this.loc).add("javaModifiers", this.javaModifiers).add("allModifiers", this.all).toString();
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public Set<ModifierOrAnnotationTypeInfo> getDuplicates() {
        assert (this.resolved) : "modifiers have not been resolved";
        return this.duplicates;
    }

    public Set<ModifierOrAnnotationTypeInfo> all() {
        assert (this.resolved) : "modifiers have not been resolved";
        return this.allTypes.get();
    }

    public ModifierOrAnnotation get(ModifierOrAnnotationTypeInfo modifier) {
        assert (this.assertIsResolvedForInput(modifier)) : "modifier is not resolved";
        return this.all.get(modifier.getEquivalenceWrapper());
    }

    private boolean assertIsResolvedForInput(ModifierOrAnnotationTypeInfo modifier) {
        if (this.resolved) {
            return true;
        }
        return modifier.accept(new ModifierOrAnnotationVisitor<Boolean>(){

            @Override
            public Boolean visit(StandardAnnotationTypeInfo type) {
                return false;
            }

            @Override
            public Boolean visit(ModifierTypeInfo type) {
                return true;
            }
        });
    }

    Collection<ModifierOrAnnotation> allNodes() {
        return this.all.values();
    }

    private static class AllSupplier
    implements Supplier<Set<ModifierOrAnnotationTypeInfo>> {
        private final Map<Equivalence.Wrapper<TypeInfo>, ModifierOrAnnotation> all;

        private AllSupplier(Map<Equivalence.Wrapper<TypeInfo>, ModifierOrAnnotation> all) {
            this.all = all;
        }

        @Override
        public Set<ModifierOrAnnotationTypeInfo> get() {
            return MODIFIER_TYPES_INTERNER.intern(TypeInfoEquivalence.unwrapSet(this.all.keySet()));
        }
    }
}

