/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member.bridge;

import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.bridge.Bridge;
import apex.jorje.semantic.ast.member.bridge.BridgeMethodCreator;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.common.iterator.EqualPairIterator;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodNameMangler;
import apex.jorje.semantic.symbol.member.method.MethodUtil;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.ArgumentTypeInfoConverter;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class InterfaceBridge
implements Bridge {
    private static final InterfaceBridge INSTANCE = new InterfaceBridge();
    private static final Set<ModifierTypeInfo> STATIC_AND_ABSTRACT = ImmutableSet.of(ModifierTypeInfos.STATIC, ModifierTypeInfos.ABSTRACT);

    private InterfaceBridge() {
    }

    public static InterfaceBridge get() {
        return INSTANCE;
    }

    @Override
    public List<Supplier<Method>> create(BridgeMethodCreator definingNode, MethodInfo methodImpl) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MethodInfo methodInterface : methodImpl.getMethodInterfaces()) {
            MethodInfo rawMethodInterface = MethodUtil.getUnreifiedMethod(methodInterface);
            boolean shouldBridge = GenericTypeInfoUtil.isUserGenericInterface(rawMethodInterface.getDefiningType()) || !TypeInfoEquivalence.isEquivalent(methodImpl.getReturnType(), methodInterface.getReturnType()) || !this.isEquivalentTypedSignature(methodImpl.getSignature(), rawMethodInterface.getSignature()) || methodImpl.getModifiers().has(ModifierTypeInfos.STATIC) || !Objects.equals(methodImpl.getName(), rawMethodInterface.getName());
            if (!shouldBridge) continue;
            builder.add(new InterfaceSupplier(definingNode, methodImpl, methodInterface));
        }
        return builder.build();
    }

    private boolean isEquivalentTypedSignature(Signature left, Signature right) {
        for (Pair<TypeInfo, TypeInfo> pair : EqualPairIterator.iterable(left.getParameterTypes(), right.getParameterTypes())) {
            if (TypeInfoEquivalence.isEquivalent((TypeInfo)pair.left, (TypeInfo)pair.right)) continue;
            return false;
        }
        return true;
    }

    private static class InterfaceSupplier
    implements Supplier<Method> {
        private final AstNode definingNode;
        private final MethodInfo methodImpl;
        private final MethodInfo methodInterface;
        private final boolean isUserGenericInterface;

        private InterfaceSupplier(BridgeMethodCreator definingNode, MethodInfo methodImpl, MethodInfo methodInterface) {
            this.definingNode = definingNode;
            this.methodImpl = methodImpl;
            this.methodInterface = methodInterface;
            this.isUserGenericInterface = GenericTypeInfoUtil.isUserGenericInterface(methodInterface.getDefiningType());
        }

        @Override
        public Method get() {
            ImmutableCollection parameters;
            ImmutableList.Builder builder;
            int i;
            TypeInfo definingType = this.definingNode.getDefiningType();
            String name = this.isUserGenericInterface ? MethodNameMangler.getGenericInterfaceMangled(this.methodInterface.getDefiningType(), this.methodInterface.getName()) : this.methodInterface.getMangledName();
            TypeInfo returnType = this.createReturnType(this.isUserGenericInterface);
            if (MethodUtil.isReifiedMethod(this.methodInterface)) {
                i = 0;
                builder = ImmutableList.builder();
                for (Parameter parameter : MethodUtil.getUnreifiedMethod(this.methodInterface).getParameters()) {
                    builder.add(Parameter.builder().setDefiningType(definingType).setType(ArgumentTypeInfoConverter.convertType(parameter.getType())).setName("arg" + i++).setModifiers(parameter.getModifierInfo()).build());
                }
                parameters = builder.build();
            } else {
                i = 0;
                builder = ImmutableList.builder();
                for (Parameter parameter : this.methodInterface.getParameters()) {
                    builder.add(Parameter.builder().setDefiningType(definingType).setType(parameter.getType()).setName("arg" + i++).setModifiers(parameter.getModifierInfo()).build());
                }
                parameters = builder.build();
            }
            ModifierGroup modifiers = this.methodImpl.getModifiers().copy().removeModifiers(STATIC_AND_ABSTRACT).addModifiers(ModifierTypeInfos.BRIDGE).build();
            SimpleStatement root = new SimpleStatement(this.definingNode, SimpleStatement.Returnable.YES, (List)((Object)parameters), returnType){
                final /* synthetic */ List val$parameters;
                final /* synthetic */ TypeInfo val$returnType;
                {
                    this.val$parameters = list;
                    this.val$returnType = typeInfo;
                    super(definingNode, isReturnable);
                }

                @Override
                public void emit(Emitter emitter) {
                    if (!methodImpl.getModifiers().has(ModifierTypeInfos.STATIC)) {
                        emitter.emitVar(Locations.NONE, 25, 0);
                    }
                    for (int i = 0; i < methodImpl.getParameterTypes().size(); ++i) {
                        emitter.emitVar(Locations.NONE, 25, i + 1);
                        TypeConversion.emit(Locations.NONE, emitter, ((Parameter)this.val$parameters.get(i)).getType(), methodImpl.getParameterTypes().get(i));
                    }
                    int opcode = methodImpl.getModifiers().has(ModifierTypeInfos.STATIC) ? 184 : 183;
                    AsmMethod bridge = AsmMethod.builder().setOpcode(opcode).setDefiningTypeAsBytecodeMethodName(methodImpl.getDefiningType()).setFunction(methodImpl.getMangledCanonicalName()).setSignature(methodImpl.getSignature()).build();
                    emitter.emit(Locations.NONE, bridge);
                    TypeConversion.emit(Locations.NONE, emitter, this.val$returnType, methodImpl.getReturnType());
                    if (methodInterface.hasReturnValue()) {
                        if (!methodImpl.hasReturnValue()) {
                            emitter.emit(Locations.NONE, 1);
                        }
                        emitter.emit(Locations.NONE, 176);
                    } else {
                        if (methodImpl.hasReturnValue()) {
                            emitter.emit(Locations.NONE, 87);
                        }
                        emitter.emit(Locations.NONE, 177);
                    }
                }
            };
            return MethodFactory.create(this.definingNode, StandardMethodInfo.builder().setDefiningType(definingType).setReturnType(returnType).setName(name).setModifiers(modifiers).setGenerated(Generated.BRIDGE).setParameters((List<Parameter>)((Object)parameters)), root);
        }

        private TypeInfo createReturnType(boolean isUserGenericInterface) {
            if (isUserGenericInterface && this.methodImpl.hasReturnValue()) {
                return TypeInfos.OBJECT;
            }
            return GenericTypeInfoUtil.getRootTypeIfNotCollection(this.methodInterface.getReturnType());
        }
    }
}

