/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member.bridge;

import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.MethodStack;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.bridge.Bridge;
import apex.jorje.semantic.ast.member.bridge.BridgeMethodCreator;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.ObjectMethods;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class InheritanceBridge
implements Bridge {
    private static final InheritanceBridge INSTANCE = new InheritanceBridge();

    private InheritanceBridge() {
    }

    public static InheritanceBridge get() {
        return INSTANCE;
    }

    @Override
    public List<Supplier<Method>> create(BridgeMethodCreator definingNode, final MethodInfo methodInfo) {
        if (Objects.equals(methodInfo.getCanonicalName(), methodInfo.getName()) || ObjectMethods.isEqualsMethod(methodInfo) || definingNode.getDefiningType() != methodInfo.getDefiningType()) {
            return ImmutableList.of();
        }
        final ModifierGroup modifiers = methodInfo.getModifiers().copy().removeModifiers(ModifierTypeInfos.ABSTRACT).addModifiers(ModifierTypeInfos.BRIDGE).build();
        SimpleStatement root = new SimpleStatement(definingNode, SimpleStatement.Returnable.YES){

            @Override
            public void emit(Emitter emitter) {
                assert (!modifiers.has(ModifierTypeInfos.STATIC));
                emitter.emitVar(Locations.NONE, 25, 0);
                for (int i = 0; i < methodInfo.getParameterTypes().size(); ++i) {
                    emitter.emitVar(Locations.NONE, 25, i + 1);
                }
                AsmMethod bridge = AsmMethod.builder().invokeSpecial().setDefiningTypeAsBytecodeMethodName(methodInfo.getDefiningType()).setFunction(methodInfo.getMangledCanonicalName()).setSignature(methodInfo.getSignature()).build();
                emitter.emit(Locations.NONE, bridge);
                MethodStack.MethodContext method = emitter.getMethodStack().peek();
                emitter.emit(Locations.NONE, method.getMethodInfo().hasReturnValue() ? 176 : 177);
            }
        };
        return ImmutableList.of(() -> MethodFactory.create(definingNode, StandardMethodInfo.builder().setDefiningType(definingNode.getDefiningType()).setReturnType(methodInfo.getReturnType()).setName(methodInfo.getMangledName()).setModifiers(modifiers).setGenerated(Generated.BRIDGE).copyParameters(methodInfo.getParameters()), root));
    }
}

