/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.BindExpression;
import apex.jorje.semantic.ast.expression.BindExpressions;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.QueryNode;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.DatabaseEmitMethods;
import apex.jorje.semantic.common.Constants;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.PrintContexts;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.PrinterUtil;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class SoqlExpression
extends Expression
implements QueryNode {
    private final Location loc;
    private final String query;
    private final BindExpressions bindExpression;
    private final PrintContext ctx;
    private final String canonicalQuery;

    public SoqlExpression(AstNode definingNode, Expr.SoqlExpr x) {
        super(definingNode);
        this.loc = x.loc;
        this.query = x.rawQuery;
        this.ctx = PrintContexts.standard();
        this.canonicalQuery = this.print(x, this.ctx);
        this.bindExpression = new BindExpressions(this, this.ctx.getBindExprs());
    }

    private String print(Expr.SoqlExpr expr, PrintContext ctx) {
        try {
            PrinterFactory factory = PrinterUtil.get().getFactory();
            return factory.queryPrinter().print(expr.query, ctx);
        }
        catch (NullPointerException x) {
            return "";
        }
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.bindExpression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        TypeInfo validationType;
        this.bindExpression.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.bindExpression) || this.query.isEmpty() || this.ctx.getEntity() == null) {
            scope.getErrors().markInvalid(this);
            return;
        }
        TypeInfo type = symbols.lookupTypeInfoIdentifiers(this.getDefiningType(), ImmutableList.of(Constants.SCHEMA, this.ctx.getEntity().field));
        if (!type.isResolved()) {
            scope.getErrors().markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(type));
            return;
        }
        assert (type instanceof SObjectTypeInfo) : "query result should be of type sobject type info";
        ScalarTypeInfo queryType = this.ctx.isCountQuery() ? TypeInfos.INTEGER : (this.ctx.isAggregate() ? GenericTypeInfoFactory.createQueryResultList(symbols, this.getAggregateResultType(symbols)) : GenericTypeInfoFactory.createQueryResultList(symbols, type));
        this.setType(queryType);
        String realQuery = symbols.getQueryValidator().validateSoql(symbols, scope, this);
        this.bindExpression.setQuery(realQuery);
        TypeInfo typeInfo = validationType = this.ctx.isAggregate() ? this.getAggregateResultType(symbols) : type;
        if (this.ctx.isForUpdate() && !((SObjectTypeInfo)validationType).getMetadata().isEditable()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.row.lock", validationType));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        this.bindExpression.emit(emitter);
        ProfilingType.SOQL.emit(emitter, this.loc, this.query);
        emitter.emit(this.loc, this.ctx.isCountQuery() ? DatabaseEmitMethods.COUNT_QUERY_MAP : DatabaseEmitMethods.QUERY_MAP);
    }

    private TypeInfo getAggregateResultType(SymbolResolver symbols) {
        return symbols.getSymbolProvider().getAggregateResultType(this.getDefiningType());
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public BindExpressions getBindExpression() {
        return this.bindExpression;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public String getRawQuery() {
        assert (this.query.endsWith("]") && this.query.startsWith("[")) : "query is malformed: " + this.query;
        return this.query.substring(1, this.query.length() - 1);
    }

    @Override
    public String getCanonicalQuery() {
        return this.canonicalQuery;
    }

    @Override
    public List<BindExpression> getBindExpressions() {
        return this.bindExpression.getBindExpressions();
    }

    public boolean isAggregateQuery() {
        return this.ctx.isAggregate();
    }
}

