/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.EmptyReferenceExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.ReferenceContext;
import apex.jorje.semantic.ast.expression.ReferenceExpressionUtil;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.expression.SpecialAssignmentCalculator;
import apex.jorje.semantic.ast.expression.SpecialStaticExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableValidateLoadVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.resolver.VariableResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.printers.PrintContexts;
import apex.jorje.services.printers.PrinterUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.Label;

public class ReferenceExpression
extends Expression
implements ReferenceContext {
    private final Expression expression;
    private final Expression dottedExpression;
    private final ReferenceType reference;
    private final Identifier lastName;
    private final List<Identifier> names;
    private List<Variable> variables;
    private List<VariableVisitor.Context> contexts;
    private IdentifierContext previousContext;
    private TypeInfo firstSObjectTypeInfo;
    private Variable specialStatic;
    private ReferenceExpressionUtil.PeelType shouldPeelSObject;
    private int staticNumberOfNamesBound;

    private ReferenceExpression(Expression expression, ReferenceType reference, Optional<Expr> dottedExpr, List<Identifier> names, Identifier lastName) {
        super(expression);
        this.expression = expression;
        this.dottedExpression = dottedExpr.map(value -> AstNodes.get().create((AstNode)this, (Expr)value)).orElse(NOOP);
        this.names = names;
        this.reference = reference;
        this.lastName = lastName;
        this.variables = ImmutableList.of();
        this.contexts = ImmutableList.of();
        this.shouldPeelSObject = ReferenceExpressionUtil.PeelType.NONE;
        this.staticNumberOfNamesBound = 0;
    }

    public static ReferenceContext create(Expression expression, ReferenceType reference, Optional<Expr> dottedExpr, List<Identifier> names, Identifier lastName) {
        if (!dottedExpr.isPresent() && names.isEmpty()) {
            return EmptyReferenceExpression.get();
        }
        return new ReferenceExpression(expression, reference, dottedExpr, names, lastName);
    }

    public ReferenceType getReferenceType() {
        return this.reference;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.dottedExpression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.dottedExpression.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.dottedExpression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.previousContext = this.isNoopDottedExpression() ? IdentifierContext.NONE : IdentifierContext.OBJECT;
        this.shouldPeelSObject = ReferenceExpressionUtil.shouldPeelType(this.reference, this.names, this.dottedExpression);
        TypeInfo startType = ReferenceExpressionUtil.getStartType(this.getDefiningType(), this.shouldPeelSObject.isPeelable(), this.dottedExpression);
        if (this.names.isEmpty()) {
            this.setType(startType);
            return;
        }
        this.variables = symbols.lookupVariableInfo(this.getDefiningType(), this.reference, this.previousContext, startType, this.names);
        TypeInfo type = UnresolvedTypeInfoFactory.get();
        if (this.variables.isEmpty() && this.isNoopDottedExpression()) {
            VariableResolver.StaticResult staticResult = symbols.lookupStaticVariableInfo(this.getDefiningType(), this.reference, this.names);
            if (!staticResult.getVariables().isEmpty()) {
                this.variables = staticResult.getVariables();
                this.staticNumberOfNamesBound = staticResult.getPosition();
            } else {
                type = symbols.lookupTypeInfoIdentifiers(this.getDefiningType(), this.names, this.reference);
                this.staticNumberOfNamesBound = this.names.size();
                if (!type.isResolved() || TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.SYSTEM_QUICK_ACTION)) {
                    if (this.getReferenceType() == ReferenceType.LOAD && staticResult.getLegacyEarlyBoundType().isPresent()) {
                        type = staticResult.getLegacyEarlyBoundType().get();
                    } else {
                        this.specialStatic = SpecialStaticExpression.get(scope, this, this.getDefiningType(), this.reference, this.names, this.lastName);
                        if (scope.getErrors().isInvalid(this)) {
                            return;
                        }
                        if (this.specialStatic != null) {
                            if (this.reference == ReferenceType.METHOD) {
                                this.setType(this.specialStatic.getType());
                                this.previousContext = IdentifierContext.OBJECT;
                            } else {
                                this.setType(this.specialStatic.getDefiningType());
                                this.previousContext = IdentifierContext.STATIC;
                            }
                            this.setFirstSObjectTypeInfo(this.specialStatic.getDefiningType());
                            return;
                        }
                    }
                }
            }
            this.previousContext = IdentifierContext.STATIC;
        }
        if (!this.variables.isEmpty()) {
            type = Iterables.getLast(this.variables).getType();
        }
        if (!type.isResolved()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("variable.does.not.exist", PrinterUtil.get().getFactory().dottedIdentifier().print(this.names, PrintContexts.empty())));
            return;
        }
        if (this.previousContext == IdentifierContext.STATIC && !Visibility.isTypeVisibleInImplicitReference(symbols.getAccessEvaluator(), this.getDefiningType(), type, Visibility.ReferencedFromTestMethod.fromBoolean(scope.isTestMethod()), Visibility.CheckGenericTypeArguments.NO)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", type));
            return;
        }
        if (!this.variables.isEmpty() && this.variables.size() + this.staticNumberOfNamesBound != this.names.size()) {
            Identifier name = this.names.get(this.variables.size() + this.staticNumberOfNamesBound);
            scope.getErrors().markInvalid((AstNode)this, name.getLoc(), I18nSupport.getLabel("variable.does.not.exist", name.getValue()));
            return;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        VariableValidateLoadVisitor visitor = VariableValidateLoadVisitor.create(symbols, scope, this);
        this.setFirstSObjectTypeInfo(startType);
        for (int i = 0; i < this.variables.size(); ++i) {
            VariableVisitor.Context context = new VariableVisitor.Context(this.names.get(i).getLoc());
            builder.add(context);
            Variable variable = this.variables.get(i);
            context.emitLast = this.reference != ReferenceType.STORE;
            context.referenceType = this.reference;
            context.previous = this.previousContext;
            context.isLast = i + 1 == this.variables.size() && this.reference == ReferenceType.METHOD;
            context.shouldPeelSObject = i == 0 && this.shouldPeelSObject.isPeelable();
            this.setFirstSObjectTypeInfo(variable.getType());
            context.firstSObjectTypeInfo = this.firstSObjectTypeInfo;
            if (!variable.accept(visitor, context).booleanValue()) break;
            this.previousContext = IdentifierContext.OBJECT;
        }
        this.contexts = builder.build();
        this.setType(type);
    }

    @Override
    public void emit(Emitter emitter) {
        boolean emitThrowNpe;
        if (!this.isNoopDottedExpression() && !ExpressionUtil.isThisOrSuperVariableExpression(this.dottedExpression) && SpecialAssignmentCalculator.get().calculate(this.expression)) {
            switch (this.reference) {
                case LOAD: {
                    this.dottedExpression.emit(emitter);
                    emitter.emit(Locations.NONE, 89);
                    break;
                }
                case STORE: {
                    emitter.emit(Locations.NONE, 95);
                    break;
                }
                case CLASS: 
                case NONE: 
                case METHOD: {
                    throw new UnexpectedCodePathException("Class and Method wrong emit path");
                }
            }
        } else {
            this.dottedExpression.emit(emitter);
        }
        if (this.reference == ReferenceType.METHOD && this.specialStatic != null) {
            VariableVisitor.Context context = new VariableVisitor.Context(Iterables.getLast(this.names).getLoc());
            this.specialStatic.accept(emitter.getVariableVisitors().peek(), context);
            return;
        }
        int index = 0;
        if (this.shouldThrowNpe()) {
            emitThrowNpe = true;
        } else if (!this.variables.isEmpty() && this.isNoopDottedExpression() && this.variables.get(0).getType().getBasicType() == BasicType.SOBJECT) {
            this.emitVariable(emitter, index++);
            emitThrowNpe = true;
        } else {
            emitThrowNpe = false;
        }
        if (this.reference != ReferenceType.STORE && emitThrowNpe && (this.variables.size() > index || this.reference == ReferenceType.LOAD)) {
            this.emitThrowNpe(emitter);
        }
        while (index < this.variables.size()) {
            this.emitVariable(emitter, index);
            ++index;
        }
    }

    private boolean shouldThrowNpe() {
        return !this.isNoopDottedExpression() && (this.dottedExpression.getType().getBasicType() == BasicType.SOBJECT || this.shouldPeelSObject == ReferenceExpressionUtil.PeelType.NESTED_AGGREGATE || this.shouldPeelSObject == ReferenceExpressionUtil.PeelType.QUERY_RESULT_WITHOUT_SOQL);
    }

    @Override
    public Location getLoc() {
        return Locations.from(this.names.get(0).getLoc(), Iterables.getLast(this.names).getLoc());
    }

    private void emitThrowNpe(Emitter emitter) {
        Location loc = this.reference != ReferenceType.METHOD || this.names.isEmpty() ? this.expression.getLoc() : Iterables.getLast(this.names).getLoc();
        emitter.emit(loc, 89);
        Label branch = new Label();
        emitter.emitJump(loc, 199, branch);
        emitter.emit(loc, SystemEmitMethods.THROW_NPE);
        emitter.emit(branch);
    }

    private void emitVariable(Emitter emitter, int index) {
        VariableVisitor.Context context = this.contexts.get(index);
        Variable variable = this.variables.get(index);
        variable.accept(emitter.getVariableVisitors().peek(), context);
    }

    @Override
    public TypeInfo getType(Expression expression) {
        return this.getType();
    }

    @Override
    public Expression getDottedExpression() {
        return this.dottedExpression;
    }

    @Override
    public Expression getExpression() {
        return this;
    }

    @Override
    public List<Variable> getVariables() {
        return this.variables;
    }

    @Override
    public List<VariableVisitor.Context> getContexts() {
        return this.contexts;
    }

    @Override
    public List<Identifier> getNames() {
        return this.names;
    }

    @Override
    public IdentifierContext getContext() {
        return this.previousContext;
    }

    @Override
    public TypeInfo getFirstSObjectTypeInfo() {
        return this.firstSObjectTypeInfo;
    }

    private void setFirstSObjectTypeInfo(TypeInfo type) {
        if (this.firstSObjectTypeInfo == null && type.getBasicType() == BasicType.SOBJECT) {
            this.firstSObjectTypeInfo = type;
        }
    }

    @Override
    public Variable getSpecialStatic() {
        return this.specialStatic;
    }

    @Override
    public boolean shouldPeelSObject() {
        return this.names.isEmpty() && this.shouldPeelSObject.isPeelable();
    }

    @Override
    public int getStaticNumberOfNamesBound() {
        return this.staticNumberOfNamesBound;
    }

    public boolean isNoopDottedExpression() {
        return this.dottedExpression == NOOP;
    }
}

