/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.PrefixOp;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.DecimalEmitMethods;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import org.objectweb.asm.Label;

public class PrefixExpression
extends Expression {
    private final PrefixOp op;
    private final Location loc;
    private final Expression expression;
    private final Expression store;

    public PrefixExpression(AstNode definingNode, Expr.PrefixExpr expr) {
        super(definingNode);
        this.op = expr.op;
        this.loc = Locations.from(expr);
        this.store = this.op.isIncOrDec() ? AstNodes.get().createStore(this, expr.expr) : NOOP;
        this.expression = AstNodes.get().create((AstNode)this, expr.expr);
    }

    @Override
    public void setTopLevel() {
        super.setTopLevel();
        if (this.op == PrefixOp.POSITIVE) {
            this.expression.setTopLevel();
        }
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (this.op == PrefixOp.POSITIVE || visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.expression.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.expression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.store.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.store)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.setType(this.expression.getType());
        switch (this.op) {
            case POSITIVE: {
                break;
            }
            case NEGATIVE: {
                if (this.getType().getBasicType().isNumber()) break;
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.negate.prefix.operand"));
                break;
            }
            case NOT: {
                if (this.getType().getBasicType() != BasicType.NULL && Distance.get().canAssign(this.getDefiningType(), this.getType(), TypeInfos.BOOLEAN)) break;
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.boolean.prefix.operand", new Object[]{this.op}));
                break;
            }
            case BITWISE_COMPLEMENT: {
                if (this.getType().getBasicType().isIntegerOrLong()) break;
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.type.bitwise.negate", this.getType()));
                break;
            }
            case INC: {
                if (this.getType().getBasicType().isNumber()) break;
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.numeric.prefix.increment", this.getType()));
                break;
            }
            case DEC: {
                if (this.getType().getBasicType().isNumber()) break;
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.numeric.prefix.decrement", this.getType()));
            }
        }
    }

    @Override
    public void emit(Emitter emitter) {
        switch (this.op) {
            case POSITIVE: {
                this.expression.emit(emitter);
                break;
            }
            case NEGATIVE: {
                this.expression.emit(emitter);
                emitter.unbox(this.getType());
                switch (this.getType().getBasicType()) {
                    case DECIMAL: {
                        emitter.emit(this.loc, DecimalEmitMethods.NEGATE);
                        break;
                    }
                    case DOUBLE: {
                        emitter.emit(this.loc, 119);
                        break;
                    }
                    case LONG: {
                        emitter.emit(this.loc, 117);
                        break;
                    }
                    case INTEGER: {
                        emitter.emit(this.loc, 116);
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
                emitter.box(this.getType());
                break;
            }
            case NOT: {
                Label trueLabel = new Label();
                Label exit = new Label();
                this.expression.emit(emitter);
                emitter.unbox(this.getType());
                emitter.emitJump(this.loc, 154, trueLabel);
                emitter.push(this.loc, true);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.emitJump(this.loc, 167, exit);
                emitter.emit(trueLabel);
                emitter.push(this.loc, false);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.emit(exit);
                break;
            }
            case BITWISE_COMPLEMENT: {
                this.expression.emit(emitter);
                emitter.unbox(this.getType());
                switch (this.getType().getBasicType()) {
                    case LONG: {
                        emitter.push(this.loc, -1L);
                        emitter.emit(this.loc, 131);
                        break;
                    }
                    case INTEGER: {
                        emitter.emit(this.loc, 2);
                        emitter.emit(this.loc, 130);
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
                emitter.box(this.getType());
                break;
            }
            case INC: {
                this.expression.emit(emitter);
                switch (this.getType().getBasicType()) {
                    case DECIMAL: {
                        emitter.emit(this.loc, 4);
                        emitter.box(TypeInfos.INTEGER);
                        TypeConversion.emit(this.loc, emitter, TypeInfos.INTEGER, this.getType());
                        emitter.emit(this.loc, DecimalEmitMethods.ADD);
                        break;
                    }
                    case DOUBLE: {
                        emitter.unbox(this.getType());
                        emitter.emit(this.loc, 15);
                        emitter.emit(this.loc, 99);
                        emitter.box(this.getType());
                        break;
                    }
                    case LONG: {
                        emitter.unbox(this.getType());
                        emitter.emit(this.loc, 10);
                        emitter.emit(this.loc, 97);
                        emitter.box(this.getType());
                        break;
                    }
                    case INTEGER: {
                        emitter.unbox(this.getType());
                        emitter.emit(this.loc, 4);
                        emitter.emit(this.loc, 96);
                        emitter.box(this.getType());
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
                if (!this.isTopLevel()) {
                    emitter.emit(this.loc, 89);
                }
                this.store.emit(emitter);
                break;
            }
            case DEC: {
                this.expression.emit(emitter);
                switch (this.getType().getBasicType()) {
                    case DECIMAL: {
                        emitter.emit(this.loc, 4);
                        emitter.box(TypeInfos.INTEGER);
                        TypeConversion.emit(this.loc, emitter, TypeInfos.INTEGER, this.getType());
                        emitter.emit(this.loc, DecimalEmitMethods.SUBTRACT);
                        break;
                    }
                    case DOUBLE: {
                        emitter.unbox(this.getType());
                        emitter.emit(this.loc, 15);
                        emitter.emit(this.loc, 103);
                        emitter.box(this.getType());
                        break;
                    }
                    case LONG: {
                        emitter.unbox(this.getType());
                        emitter.emit(this.loc, 10);
                        emitter.emit(this.loc, 101);
                        emitter.box(this.getType());
                        break;
                    }
                    case INTEGER: {
                        emitter.unbox(this.getType());
                        emitter.emit(this.loc, 4);
                        emitter.emit(this.loc, 100);
                        emitter.box(this.getType());
                        break;
                    }
                    default: {
                        throw new UnexpectedCodePathException();
                    }
                }
                if (!this.isTopLevel()) {
                    emitter.emit(this.loc, 89);
                }
                this.store.emit(emitter);
            }
        }
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public PrefixOp getOp() {
        return this.op;
    }
}

