/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.common.base.Result;
import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.NewObject;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.NewObjectHelperEmitMethods;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.bcl.SObjectEmitMethods;
import apex.jorje.semantic.common.StandardI18nSupplier;
import apex.jorje.semantic.common.iterator.EqualPairIterator;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.SignatureUtil;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.JavaTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.VfComponentTypeInfo;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.semantic.symbol.visibility.MethodCallVisibility;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.symbol.visibility.VisibleApiVersionUtil;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class NewObjectExpression
extends Expression {
    private final Location loc;
    private final TypeRef typeRef;
    private final List<Expression> parameters;
    private TypeInfo type;
    private MethodInfo constructor;

    public NewObjectExpression(AstNode definingNode, Expr.NewExpr expr, NewObject.NewStandard x) {
        super(definingNode);
        this.loc = expr.loc;
        this.typeRef = x.type;
        this.parameters = AstNodes.get().createExpressions(this, x.inputParameters);
    }

    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (Expression expression : this.parameters) {
                expression.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(final SymbolResolver symbols, final ValidationScope scope) {
        final Errors errors = scope.getErrors();
        if (this.typeRef == null) {
            errors.markInvalid(this);
            return;
        }
        this.type = symbols.lookupTypeInfo(this.getDefiningType(), this.typeRef);
        if (!this.type.isResolved()) {
            errors.markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.type));
            return;
        }
        if (!Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.type, Visibility.ReferencedFromTestMethod.fromBoolean(scope.isTestMethod()), Visibility.CheckGenericTypeArguments.YES)) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", this.type));
            return;
        }
        if (this.type.getModifiers().has(ModifierTypeInfos.ABSTRACT)) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.new.abstract", this.type));
            return;
        }
        this.type.accept(new TypeInfoVisitor.Default<Void>(){

            @Override
            protected Void _default(TypeInfo type) {
                StandardI18nSupplier provider;
                ImmutableList.Builder parameterTypesBuilder = new ImmutableList.Builder();
                for (Expression expression : NewObjectExpression.this.parameters) {
                    expression.validate(symbols, scope);
                    parameterTypesBuilder.add(expression.getType());
                }
                ImmutableCollection parameterTypes = parameterTypesBuilder.build();
                if (errors.isInvalid(NewObjectExpression.this.parameters)) {
                    errors.markInvalid(NewObjectExpression.this);
                    return null;
                }
                Result<MethodInfo> result = symbols.lookupMethodInfo(NewObjectExpression.this.getDefiningType(), IdentifierContext.NONE, type, "<init>", (List<TypeInfo>)((Object)parameterTypes));
                StandardI18nSupplier standardI18nSupplier = provider = type.methods().hasConstructors() ? StandardI18nSupplier.create("unknown.constructor", type.toString(), SignatureUtil.parameterTypesToString((List<TypeInfo>)((Object)parameterTypes))) : StandardI18nSupplier.create("type.not.constructable", type);
                if (errors.addIfError((AstNode)NewObjectExpression.this, result, provider)) {
                    return null;
                }
                NewObjectExpression.this.constructor = result.get();
                List<String> visibilityErrors = MethodCallVisibility.calculate(NewObjectExpression.this.getDefiningType(), symbols.getAccessEvaluator(), Visibility.ReferencedFromTestMethod.fromBoolean(scope.isTestMethod()), NewObjectExpression.this.constructor);
                if (!visibilityErrors.isEmpty()) {
                    errors.markInvalid((AstNode)NewObjectExpression.this, visibilityErrors);
                    return null;
                }
                errors.addIfError((AstNode)NewObjectExpression.this, NewObjectExpression.this.getLoc(), VisibleApiVersionUtil.checkApiVisible(symbols.getAccessEvaluator(), NewObjectExpression.this.getDefiningType(), NewObjectExpression.this.constructor.getSignature().toString(), NewObjectExpression.this.constructor.getModifiers(), NewObjectExpression.this.constructor.getMemberType()));
                return null;
            }

            private void validateComponents() {
                if (!NewObjectExpression.this.parameters.isEmpty()) {
                    errors.markInvalid((AstNode)NewObjectExpression.this, I18nSupport.getLabel("invalid.normal.constructor", NewObjectExpression.this.type));
                }
            }

            @Override
            public Void visit(SObjectTypeInfo type) {
                if (TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.SOBJECT_AGGREGATE_RESULT)) {
                    errors.markInvalid((AstNode)NewObjectExpression.this, I18nSupport.getLabel("sobject.not.constructable", type));
                }
                this.validateComponents();
                return null;
            }

            @Override
            public Void visit(VfComponentTypeInfo type) {
                this.validateComponents();
                return null;
            }
        });
        this.setType(this.type);
    }

    @Override
    public void emit(final Emitter emitter) {
        this.type.accept(new TypeInfoVisitor.Default<Void>(){

            private void visitDynamicTypeInfo(TypeInfo type) {
                emitter.emitType(NewObjectExpression.this.loc, 187, type);
                emitter.emit(NewObjectExpression.this.loc, 89);
                emitter.emit(NewObjectExpression.this.loc, ObjectEmitMethods.constructor(type));
                if (NewObjectExpression.this.isTopLevel()) {
                    emitter.emit(NewObjectExpression.this.loc, 87);
                }
            }

            @Override
            protected Void _default(TypeInfo type) {
                MethodInfo proxy = emitter.getProxyMethodTable().get(NewObjectExpression.this.getLoc(), NewObjectExpression.this.getDefiningType(), type, NewObjectExpression.this.constructor);
                emitter.emitType(NewObjectExpression.this.loc, 187, GenericTypeInfoUtil.getRootType(type));
                if (!NewObjectExpression.this.isTopLevel()) {
                    emitter.emit(NewObjectExpression.this.loc, 89);
                }
                for (Pair pair : EqualPairIterator.iterable(NewObjectExpression.this.parameters, NewObjectExpression.this.constructor.getEmitSignature().getParameterTypes())) {
                    ((Expression)pair.left).emit(emitter);
                    TypeConversion.emit(NewObjectExpression.this.loc, emitter, ((Expression)pair.left).getType(), (TypeInfo)pair.right);
                }
                AsmMethod asmMethod = proxy != null ? proxy.getAsmMethod() : NewObjectExpression.this.constructor.getAsmMethod();
                emitter.emit(NewObjectExpression.this.loc, asmMethod);
                return null;
            }

            @Override
            public Void visit(JavaTypeInfo type) {
                String className = type.getBytecodeName().startsWith("com/salesforce/api/interop/") ? type.getBytecodeName() : "com/salesforce/api/interop/" + type.getBytecodeName();
                emitter.emitType(NewObjectExpression.this.loc, 187, className);
                emitter.emit(NewObjectExpression.this.loc, 89);
                for (Pair pair : EqualPairIterator.iterable(NewObjectExpression.this.parameters, NewObjectExpression.this.constructor.getEmitSignature().getParameterTypes())) {
                    ((Expression)pair.left).emit(emitter);
                }
                emitter.emit(NewObjectExpression.this.loc, NewObjectExpression.this.constructor.getAsmMethodBuilder().setDefiningTypeName(className).build());
                if (NewObjectExpression.this.isTopLevel()) {
                    emitter.emit(NewObjectExpression.this.loc, 87);
                }
                return null;
            }

            @Override
            public Void visit(SObjectTypeInfo type) {
                if (emitter.enforceNewEmitBehavior()) {
                    emitter.push(NewObjectExpression.this.loc, type.getSubEntityBytecodeNameForCreation());
                    emitter.emit(NewObjectExpression.this.loc, NewObjectHelperEmitMethods.newSObject());
                    emitter.emitType(NewObjectExpression.this.loc, 192, type.getBytecodeName());
                    emitter.emit(NewObjectExpression.this.loc, 89);
                    emitter.emit(NewObjectExpression.this.loc, SObjectEmitMethods.initializationCompleted(SObjectTypeInfoUtil.getUnionEntityEmitType(type)));
                } else {
                    emitter.emitType(NewObjectExpression.this.loc, 187, type);
                    emitter.emit(NewObjectExpression.this.loc, 89);
                    emitter.emit(NewObjectExpression.this.loc, ObjectEmitMethods.constructor(type));
                    emitter.emit(NewObjectExpression.this.loc, 89);
                    emitter.emit(NewObjectExpression.this.loc, SObjectEmitMethods.initializationCompleted(type));
                }
                if (NewObjectExpression.this.isTopLevel()) {
                    emitter.emit(NewObjectExpression.this.loc, 87);
                }
                return null;
            }

            @Override
            public Void visit(VfComponentTypeInfo type) {
                this.visitDynamicTypeInfo(type);
                return null;
            }
        });
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public String getMethodName() {
        return String.valueOf(this.typeRef);
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public MethodInfo getConstructor() {
        return this.constructor;
    }
}

