/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.JadtFactory;
import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.MapLiteralKeyValue;
import apex.jorje.data.ast.NewObject;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.CollectionExpressionUtils;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.MapEntryNode;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.MapMethods;
import apex.jorje.semantic.bcl.NewObjectHelperEmitMethods;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class NewMapLiteralExpression
extends Expression {
    private final Location loc;
    private final List<TypeRef> types;
    private final List<MapEntryNode> entries;
    private GenericTypeInfo mapType;
    private TypeInfo keyType;
    private TypeInfo valueType;
    private AsmMethod putMethod;

    public NewMapLiteralExpression(AstNode definingNode, Expr.NewExpr expr, NewObject.NewMapLiteral x) {
        super(definingNode);
        this.loc = expr.loc;
        this.types = x.types;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MapLiteralKeyValue entry : AstNodes.filterNotNull(x.pairs)) {
            builder.add(new MapEntryNode(this, AstNodes.get().create((AstNode)this, entry.key), AstNodes.get().create((AstNode)this, entry.value)));
        }
        this.entries = builder.build();
    }

    public TypeRef getTypeRef() {
        return TypeRefs.newClassTypeRef(JadtFactory.MAP, this.types);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (MapEntryNode entry : this.entries) {
                entry.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        Errors errors = scope.getErrors();
        if (this.types.size() != 2) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.map.init"));
            return;
        }
        TypeRef keyTypeRef = this.types.get(0);
        TypeRef valueTypeRef = this.types.get(1);
        if (keyTypeRef == null || valueTypeRef == null) {
            errors.markInvalid(this);
            return;
        }
        this.keyType = symbols.lookupTypeInfo(this.getDefiningType(), keyTypeRef);
        this.valueType = symbols.lookupTypeInfo(this.getDefiningType(), valueTypeRef);
        if (!CollectionExpressionUtils.validateMap(this.getDefiningType(), this.keyType, this.valueType, scope, this)) {
            return;
        }
        this.mapType = GenericTypeInfoFactory.createMap(symbols, this.keyType, this.valueType);
        for (MapEntryNode entry : this.entries) {
            entry.validate(symbols, scope);
            if (!errors.isInvalid(entry)) continue;
            errors.markInvalid(this);
        }
        this.setType(this.mapType);
    }

    @Override
    public void emit(Emitter emitter) {
        String bytecodeName = TypeEraser.eraseBytecodeName(this.mapType);
        this.putMethod = MapMethods.put(bytecodeName);
        if (emitter.enforceNewEmitBehavior()) {
            emitter.push(this.loc, TypeEraser.eraseBytecodeName(this.mapType, TypeEraser.CustomErasureType.UNION_SUB_ENTITY));
            emitter.emit(this.loc, NewObjectHelperEmitMethods.newMap());
            emitter.emitType(this.loc, 192, bytecodeName);
        } else {
            emitter.emitType(this.loc, 187, bytecodeName);
            emitter.emit(this.loc, 89);
            emitter.emit(this.loc, ObjectEmitMethods.constructor(bytecodeName));
        }
        for (MapEntryNode entry : this.entries) {
            entry.emit(emitter);
        }
        if (this.isTopLevel()) {
            emitter.emit(this.loc, 87);
        }
        this.putMethod = null;
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    TypeInfo getKeyType() {
        assert (this.keyType != null);
        return this.keyType;
    }

    TypeInfo getValueType() {
        assert (this.valueType != null);
        return this.valueType;
    }

    AsmMethod getPutMethod() {
        return this.putMethod;
    }
}

