/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.JadtFactory;
import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.NewObject;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.CollectionExpressionUtils;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.NewObjectHelperEmitMethods;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.bcl.validators.MapPutAllValidator;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import apex.jorje.services.I18nSupport;
import java.util.List;

public class NewMapInitExpression
extends Expression {
    private final Location loc;
    private final List<TypeRef> types;
    private final Expression init;
    private GenericTypeInfo mapType;

    public NewMapInitExpression(AstNode definingNode, Expr.NewExpr expr, NewObject.NewMapInit x) {
        super(definingNode);
        this.loc = expr.loc;
        this.types = x.types;
        this.init = x.expr.map(value -> AstNodes.get().create((AstNode)this, (Expr)value)).orElse(NOOP);
    }

    public TypeRef getTypeRef() {
        return TypeRefs.newClassTypeRef(JadtFactory.MAP, this.types);
    }

    private static boolean isInvalidInit(Expression init, TypeInfo type) {
        return init != NOOP && (!CollectionTypeInfoUtil.isMap(init.getType()) || !TypeInfoEquivalence.isEquivalent(init.getType(), type)) && MapPutAllValidator.isInvalidMapInitializationFromList(init.getDefiningType(), type, init.getType());
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.init.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.init.validate(symbols, scope);
        Errors errors = scope.getErrors();
        if (errors.isInvalid(this.init)) {
            errors.markInvalid(this);
            return;
        }
        if (this.types.size() != 2) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.parameterized.type.count", "Map", 2, this.types.size()));
            return;
        }
        TypeRef keyTypeRef = this.types.get(0);
        TypeRef valueTypeRef = this.types.get(1);
        if (keyTypeRef == null || valueTypeRef == null) {
            errors.markInvalid(this);
            return;
        }
        TypeInfo keyType = symbols.lookupTypeInfo(this.getDefiningType(), keyTypeRef);
        TypeInfo valueType = symbols.lookupTypeInfo(this.getDefiningType(), valueTypeRef);
        boolean isValidMap = CollectionExpressionUtils.validateMap(this.getDefiningType(), keyType, valueType, scope, this);
        if (!isValidMap) {
            return;
        }
        this.mapType = GenericTypeInfoFactory.createMap(symbols, keyType, valueType);
        if (NewMapInitExpression.isInvalidInit(this.init, this.mapType)) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.map.initializer", this.init.getType(), keyType, valueType));
            return;
        }
        this.setType(this.mapType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void emit(Emitter emitter) {
        String bytecodeName = TypeEraser.eraseBytecodeName(this.mapType);
        if (emitter.enforceNewEmitBehavior()) {
            emitter.push(this.loc, TypeEraser.eraseBytecodeName(this.mapType, TypeEraser.CustomErasureType.UNION_SUB_ENTITY));
            if (this.init == Expression.NOOP) {
                emitter.emit(this.loc, NewObjectHelperEmitMethods.newMap());
                emitter.emitType(this.loc, 192, bytecodeName);
            } else if (this.init.getType().getBasicType() == BasicType.MAP) {
                this.init.emit(emitter);
                emitter.emit(this.loc, NewObjectHelperEmitMethods.newMapWithMap());
                emitter.emitType(this.loc, 192, bytecodeName);
            } else if (ExpressionUtil.isListInitWithSize(this.init)) {
                this.init.emit(emitter);
                emitter.emit(this.loc, NewObjectHelperEmitMethods.newListWithSize());
                emitter.emitType(this.loc, 192, bytecodeName);
            } else {
                if (!CollectionTypeInfoUtil.isList(this.init.getType())) throw new UnexpectedCodePathException();
                this.init.emit(emitter);
                emitter.emit(this.loc, NewObjectHelperEmitMethods.newMapWithList());
                emitter.emitType(this.loc, 192, bytecodeName);
            }
        } else {
            AsmMethod constructor;
            emitter.emitType(this.loc, 187, bytecodeName);
            emitter.emit(this.loc, 89);
            this.init.emit(emitter);
            if (this.init == Expression.NOOP) {
                constructor = ObjectEmitMethods.constructor(bytecodeName);
            } else if (this.init.getType().getBasicType() == BasicType.MAP) {
                constructor = ObjectEmitMethods.constructor(bytecodeName, TypeInfos.MAP);
            } else {
                if (!CollectionTypeInfoUtil.isList(this.init.getType())) throw new UnexpectedCodePathException();
                constructor = ObjectEmitMethods.constructor(bytecodeName, TypeInfos.LIST);
            }
            emitter.emit(this.loc, constructor);
        }
        if (!this.isTopLevel()) return;
        emitter.emit(this.loc, 87);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }
}

