/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.JadtFactory;
import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.NewObject;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.CollectionExpressionUtils;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.ListEmitMethods;
import apex.jorje.semantic.bcl.NewObjectHelperEmitMethods;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import apex.jorje.services.I18nSupport;
import java.util.List;

public class NewListLiteralExpression
extends Expression {
    private final Location loc;
    private final List<TypeRef> types;
    private final List<Expression> elements;
    private GenericTypeInfo type;

    public NewListLiteralExpression(AstNode definingNode, Expr.NewExpr expr, NewObject.NewListLiteral x) {
        super(definingNode);
        this.loc = expr.loc;
        this.types = x.types;
        this.elements = AstNodes.get().createExpressions(this, x.values);
    }

    public TypeRef getTypeRef() {
        return TypeRefs.newClassTypeRef(JadtFactory.LIST, this.types);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (Expression element : this.elements) {
                element.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        Errors errors = scope.getErrors();
        if (this.types.size() != 1) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.list.init"));
            return;
        }
        TypeRef elementTypeRef = this.types.get(0);
        if (elementTypeRef == null) {
            errors.markInvalid(this);
            return;
        }
        TypeInfo elementType = symbols.lookupTypeInfo(this.getDefiningType(), elementTypeRef);
        if (!CollectionExpressionUtils.validateList(this.getDefiningType(), elementType, scope, this)) {
            return;
        }
        for (Expression element : this.elements) {
            element.validate(symbols, scope);
            if (errors.isInvalid(element)) {
                errors.markInvalid(this);
                continue;
            }
            if (Distance.get().canAssign(this.getDefiningType(), element.getType(), elementType)) continue;
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.list.initial.expression.type", elementType, element.getType()));
        }
        this.type = GenericTypeInfoFactory.createList(symbols, elementType);
        this.setType(this.type);
    }

    @Override
    public void emit(Emitter emitter) {
        String bytecodeName = TypeEraser.eraseBytecodeName(this.type);
        if (emitter.enforceNewEmitBehavior()) {
            emitter.push(this.loc, TypeEraser.eraseBytecodeName(this.type, TypeEraser.CustomErasureType.UNION_SUB_ENTITY));
            emitter.emit(this.loc, NewObjectHelperEmitMethods.newList());
            emitter.emitType(this.loc, 192, bytecodeName);
        } else {
            emitter.emitType(this.loc, 187, bytecodeName);
            emitter.emit(this.loc, 89);
            emitter.emit(this.loc, ObjectEmitMethods.constructor(bytecodeName));
        }
        TypeInfo elementType = CollectionTypeInfoUtil.getElementType(this.type);
        AsmMethod addMethod = ListEmitMethods.addNoReturn(bytecodeName);
        for (Expression element : this.elements) {
            emitter.emit(this.loc, 89);
            element.emit(emitter);
            TypeConversion.emit(this.loc, emitter, element.getType(), elementType);
            emitter.emit(this.loc, addMethod);
        }
        if (this.isTopLevel()) {
            emitter.emit(this.loc, 87);
        }
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }
}

